/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.SystemInfo;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.border.Border;

public class ResizableDialog
extends JDialog
implements ResizableSupport {
    private ResizablePanel _resizablePanel;

    public ResizableDialog() throws HeadlessException {
        this.initComponents();
    }

    public ResizableDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public ResizableDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
    }

    public ResizableDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.initComponents();
    }

    public ResizableDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    public ResizableDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.initComponents();
    }

    public ResizableDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public ResizableDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
    }

    public ResizableDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.initComponents();
    }

    public ResizableDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    public ResizableDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.initComponents();
    }

    protected void initComponents() {
        this.setModal(false);
        this.setUndecorated(true);
        this._resizablePanel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int resizeDir, int newX, int newY, int newW, int newH) {
                        Container container = ResizableDialog.this.getContentPane();
                        if (SystemInfo.isJdk15Above()) {
                            container.setPreferredSize(new Dimension(newW, newH));
                        } else if (container instanceof JComponent) {
                            ((JComponent)container).setPreferredSize(new Dimension(newW, newH));
                        }
                        if (!JDialog.isDefaultLookAndFeelDecorated()) {
                            ResizableDialog.this.setBounds(newX, newY, newW, newH);
                        }
                        ResizableDialog.this.resizing();
                    }

                    public void beginResizing(int resizeCorner) {
                        super.beginResizing(resizeCorner);
                        ResizableDialog.this.beginResizing();
                    }

                    public void endResizing(int resizeCorner) {
                        super.endResizing(resizeCorner);
                        ResizableDialog.this.endResizing();
                    }

                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ResizableDialog.this._resizablePanel.setSize(ResizableDialog.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }
}

