/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBarIconsFactory;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchableBar
extends JToolBar
implements SearchableProvider {
    private Searchable _searchable;
    private JLabel _statusLabel;
    private JTextField _textField;
    protected AbstractButton _closeButton;
    protected AbstractButton _findPrevButton;
    protected AbstractButton _findNextButton;
    protected AbstractButton _highlightsButton;
    private AbstractButton _matchCaseCheckBox;
    private AbstractButton _repeatCheckBox;
    public static final int SHOW_CLOSE = 1;
    public static final int SHOW_NAVIGATION = 2;
    public static final int SHOW_HIGHLIGHTS = 4;
    public static final int SHOW_MATCHCASE = 8;
    public static final int SHOW_REPEATS = 16;
    public static final int SHOW_STATUS = 32;
    public static final int SHOW_ALL = -1;
    private int _visibleButtons = -17;
    private boolean _compact;
    private static final Color DEFAULT_MISMATCH_BACKGROUND = new Color(255, 85, 85);
    private Color _mismatchBackground;
    private Installer _installer;

    public SearchableBar(Searchable searchable) {
        this(searchable, "", false);
    }

    public SearchableBar(Searchable searchable, boolean compact) {
        this(searchable, "", compact);
    }

    public SearchableBar(Searchable searchable, String initialText, boolean compact) {
        this.setFloatable(false);
        this.setRollover(true);
        this._searchable = searchable;
        this._searchable.addSearchableListener(new SearchableListener(){

            public void searchableEventFired(SearchableEvent e) {
                if (e.getID() == 3005) {
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        });
        this._searchable.setSearchableProvider(this);
        this._compact = compact;
        this.initComponents(initialText);
    }

    private void initComponents(String initialText) {
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (SearchableBar.this.getInstaller() != null) {
                    SearchableBar.this.getInstaller().closeSearchBar(SearchableBar.this);
                }
            }
        };
        AbstractAction findNextAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchableBar.this._highlightsButton.setSelected(false);
                String text = SearchableBar.this.getSearchingText();
                int cursor = SearchableBar.this._searchable.getCursor();
                int found = SearchableBar.this._searchable.findNext(text);
                if (found != -1 && SearchableBar.this._searchable.isRepeats() && found <= cursor) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedBottomRepeat"), SearchableBar.this.getImageIcon("icons/repeat.png"));
                } else if (!SearchableBar.this._searchable.isRepeats() && found == -1) {
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedBottom"), SearchableBar.this.getImageIcon("icons/error.png"));
                } else if (found != -1) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.clearStatus();
                }
            }
        };
        AbstractAction findPrevAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchableBar.this._highlightsButton.setSelected(false);
                String text = SearchableBar.this.getSearchingText();
                int cursor = SearchableBar.this._searchable.getCursor();
                int found = SearchableBar.this._searchable.findPrevious(text);
                if (found != -1 && SearchableBar.this._searchable.isRepeats() && found >= cursor) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedTopRepeat"), SearchableBar.this.getImageIcon("icons/repeat.png"));
                } else if (!SearchableBar.this._searchable.isRepeats() && found == -1) {
                    SearchableBar.this.setStatus(SearchableBar.this.getResourceString("SearchableBar.reachedTop"), SearchableBar.this.getImageIcon("icons/error.png"));
                } else if (found != -1) {
                    SearchableBar.this.select(found, text, false);
                    SearchableBar.this.clearStatus();
                }
            }
        };
        this._closeButton = this.createCloseButton(closeAction);
        this._findNextButton = this.createFindNextButton(findNextAction);
        this._findPrevButton = this.createFindPrevButton(findPrevAction);
        this._highlightsButton = this.createHighlightButton();
        this._matchCaseCheckBox = this.createMatchCaseButton();
        this._repeatCheckBox = this.createRepeatsButton();
        this._statusLabel = new JLabel();
        this._textField = this.createTextField();
        this._textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SearchableBar.this._textField.selectAll();
            }
        });
        this._textField.setColumns(13);
        this._textField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer;
            {
                this.timer = new Timer(SearchableBar.this._searchable.getSearchingDelay(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SearchableBar.this.highlightAllOrNext();
                    }
                });
            }

            public void insertUpdate(DocumentEvent e) {
                this.startTimer();
            }

            public void removeUpdate(DocumentEvent e) {
                this.startTimer();
            }

            public void changedUpdate(DocumentEvent e) {
                this.startTimer();
            }

            void startTimer() {
                if (SearchableBar.this._searchable.getSearchingDelay() > 0) {
                    if (this.timer.isRunning()) {
                        this.timer.restart();
                    } else {
                        this.timer.setRepeats(false);
                        this.timer.start();
                    }
                } else {
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        });
        this._textField.setText(initialText);
        this._textField.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(40, 0), 0);
        this._textField.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(10, 0), 0);
        this._textField.registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(38, 0), 0);
        this._textField.registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.installComponents();
        int found = this._searchable.findFromCursor(this.getSearchingText());
        if (initialText.length() != 0 && found == -1) {
            this.select(found, initialText, false);
        }
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    protected AbstractButton createCloseButton(AbstractAction closeAction) {
        JButton button = new JButton(this.getImageIcon("icons/close.png"));
        button.addActionListener(closeAction);
        button.setRolloverEnabled(true);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setOpaque(false);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setRolloverIcon(this.getImageIcon("icons/closeR.png"));
        return button;
    }

    protected AbstractButton createFindNextButton(AbstractAction findNextAction) {
        JButton button = new JButton(this._compact ? "" : this.getResourceString("SearchableBar.findNext"), this.getImageIcon("icons/next.png"));
        button.setToolTipText(this.getResourceString("SearchableBar.findNext.tooltip"));
        button.setMnemonic(this.getResourceString("SearchableBar.findNext.mnemonic").charAt(0));
        button.setRolloverIcon(this.getImageIcon("icons/nextR.png"));
        button.setDisabledIcon(this.getImageIcon("icons/nextD.png"));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.addActionListener(findNextAction);
        button.setEnabled(false);
        return button;
    }

    protected AbstractButton createFindPrevButton(AbstractAction findPrevAction) {
        JButton button = new JButton(this._compact ? "" : this.getResourceString("SearchableBar.findPrevious"), this.getImageIcon("icons/previous.png"));
        button.setToolTipText(this.getResourceString("SearchableBar.findPrevious.tooltip"));
        button.setMnemonic(this.getResourceString("SearchableBar.findPrevious.mnemonic").charAt(0));
        button.setRolloverIcon(this.getImageIcon("icons/previousR.png"));
        button.setDisabledIcon(this.getImageIcon("icons/previousD.png"));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.addActionListener(findPrevAction);
        button.setEnabled(false);
        return button;
    }

    protected AbstractButton createHighlightButton() {
        JToggleButton button = new JToggleButton(this._compact ? "" : this.getResourceString("SearchableBar.highlights"), this.getImageIcon("icons/highlights.png"));
        button.setToolTipText(this.getResourceString("SearchableBar.highlights.tooltip"));
        button.setMnemonic(this.getResourceString("SearchableBar.highlights.mnemonic").charAt(0));
        button.setSelectedIcon(this.getImageIcon("icons/highlightsS.png"));
        button.setDisabledIcon(this.getImageIcon("icons/highlightsD.png"));
        button.setRolloverIcon(this.getImageIcon("icons/highlightsR.png"));
        button.setRolloverSelectedIcon(this.getImageIcon("icons/highlightsRS.png"));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        AbstractAction highlightAllAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchableBar.this.highlightAllOrNext();
            }
        };
        button.addActionListener(highlightAllAction);
        button.setEnabled(false);
        return button;
    }

    protected AbstractButton createRepeatsButton() {
        JCheckBox button = new JCheckBox(this.getResourceString("SearchableBar.repeats"));
        button.setMnemonic(this.getResourceString("SearchableBar.repeats.mnemonic").charAt(0));
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setSelected(this.getSearchable().isRepeats());
        button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() instanceof AbstractButton) {
                    SearchableBar.this.getSearchable().setRepeats(((AbstractButton)e.getSource()).isSelected());
                }
            }
        });
        return button;
    }

    protected AbstractButton createMatchCaseButton() {
        JCheckBox checkBox = new JCheckBox(this.getResourceString("SearchableBar.matchCase"));
        checkBox.setMnemonic(this.getResourceString("SearchableBar.matchCase.mnemonic").charAt(0));
        checkBox.setRequestFocusEnabled(false);
        checkBox.setFocusable(false);
        checkBox.setSelected(this.getSearchable().isCaseSensitive());
        checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() instanceof AbstractButton) {
                    SearchableBar.this.getSearchable().setCaseSensitive(((AbstractButton)e.getSource()).isSelected());
                    SearchableBar.this.highlightAllOrNext();
                }
            }
        });
        return checkBox;
    }

    protected void installComponents() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new JideBoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(4), "fix");
        if ((this._visibleButtons & 1) != 0) {
            this.add(this._closeButton);
            this.add(Box.createHorizontalStrut(10));
        }
        JLabel label = new JLabel(this.getResourceString("SearchableBar.find"));
        label.setDisplayedMnemonic(this.getResourceString("SearchableBar.find.mnemonic").charAt(0));
        label.setLabelFor(this._textField);
        this.add(label);
        this.add(Box.createHorizontalStrut(2), "fix");
        this.add((Component)JideSwingUtilities.createCenterPanel(this._textField), "fix");
        this.add(Box.createHorizontalStrut(2), "fix");
        if ((this._visibleButtons & 2) != 0) {
            this.add(this._findNextButton);
            this.add(this._findPrevButton);
        }
        if ((this._visibleButtons & 4) != 0) {
            this.add(this._highlightsButton);
        }
        if ((this._visibleButtons & 8) != 0) {
            this.add(this._matchCaseCheckBox);
        }
        if ((this._visibleButtons & 0x10) != 0) {
            this.add(this._repeatCheckBox);
        }
        if ((this._visibleButtons & 0x20) != 0) {
            this.add(Box.createHorizontalStrut(24));
            this.add((Component)this._statusLabel, "vary");
        }
        this.add(Box.createHorizontalStrut(6), "fix");
    }

    private void highlightAllOrNext() {
        if (this._highlightsButton.isSelected()) {
            this.highlighAll();
        } else {
            this.highlightNext();
        }
    }

    private void highlighAll() {
        String text = this.getSearchingText();
        if (text == null || text.length() == 0) {
            return;
        }
        boolean old = this._searchable.isRepeats();
        this._searchable.setRepeats(false);
        int index = this._searchable.findFirst(text);
        if (index != -1) {
            this._searchable.setSelectedIndex(index, false);
            this._searchable.setCursor(index);
            this._findNextButton.setEnabled(true);
            this._findPrevButton.setEnabled(true);
            this._highlightsButton.setEnabled(true);
            this.clearStatus();
        } else {
            this.select(-1, text, false);
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.setStatus(this.getResourceString("SearchableBar.notFound"), this.getImageIcon("icons/error.png"));
        }
        int firstIndex = -1;
        while (index != -1) {
            int newIndex = this._searchable.findNext(text);
            if ((index = index == newIndex ? -1 : newIndex) == -1) continue;
            if (firstIndex == -1) {
                firstIndex = index;
            }
            this.select(index, text, true);
        }
        if (firstIndex != -1) {
            this.select(firstIndex, text, true);
        }
        this._searchable.setRepeats(old);
        this._searchable.setCursor(0);
    }

    private void highlightNext() {
        String text = this.getSearchingText();
        if (text == null || text.length() == 0) {
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.clearStatus();
            return;
        }
        int found = this._searchable.findFromCursor(text);
        if (found == -1) {
            this.select(-1, "", false);
            this._findNextButton.setEnabled(false);
            this._findPrevButton.setEnabled(false);
            this._highlightsButton.setEnabled(false);
            this.setStatus(this.getResourceString("SearchableBar.notFound"), this.getImageIcon("icons/error.png"));
        } else {
            this.select(found, text, false);
            this._findNextButton.setEnabled(true);
            this._findPrevButton.setEnabled(true);
            this._highlightsButton.setEnabled(true);
            this.clearStatus();
        }
    }

    private void clearStatus() {
        this._statusLabel.setIcon(null);
        this._statusLabel.setText("");
        this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
    }

    private void setStatus(String message, Icon icon) {
        this._statusLabel.setIcon(icon);
        this._statusLabel.setText(message);
    }

    public void focusSearchField() {
        if (this._textField != null) {
            this._textField.requestFocus();
        }
    }

    protected void select(int index, String searchingText, boolean incremental) {
        if (index != -1) {
            this._searchable.setSelectedIndex(index, incremental);
            this._searchable.setCursor(index);
            this._textField.setBackground(UIDefaultsLookup.getColor("TextField.background"));
        } else {
            this._searchable.setSelectedIndex(-1, false);
            this._textField.setBackground(this.getMismatchBackground());
        }
        this._searchable.firePropertyChangeEvent(searchingText);
        if (index != -1) {
            Object element = this._searchable.getElementAt(index);
            this._searchable.fireSearchableEvent(new SearchableEvent(this._searchable, 3002, searchingText, element, this._searchable.convertElementToString(element)));
        } else {
            this._searchable.fireSearchableEvent(new SearchableEvent(this._searchable, 3003, searchingText));
        }
    }

    public String getSearchingText() {
        return this._textField != null ? this._textField.getText() : "";
    }

    public void setSearchingText(String searchingText) {
        if (this._textField != null) {
            this._textField.setText(searchingText);
        }
    }

    public boolean isPassive() {
        return false;
    }

    public void setMismatchForeground(Color mismatchBackground) {
        this._mismatchBackground = mismatchBackground;
    }

    public Color getMismatchBackground() {
        if (this._mismatchBackground == null) {
            return DEFAULT_MISMATCH_BACKGROUND;
        }
        return this._mismatchBackground;
    }

    public Installer getInstaller() {
        return this._installer;
    }

    public void setInstaller(Installer installer) {
        this._installer = installer;
    }

    public static SearchableBar install(Searchable searchable, KeyStroke keyStroke, Installer installer) {
        final SearchableBar searchableBar = new SearchableBar(searchable);
        searchableBar.setInstaller(installer);
        ((JComponent)searchable.getComponent()).registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                searchableBar.getInstaller().openSearchBar(searchableBar);
                searchableBar.focusSearchField();
            }
        }, keyStroke, 1);
        return searchableBar;
    }

    public void processKeyEvent(KeyEvent e) {
    }

    public int getVisibleButtons() {
        return this._visibleButtons;
    }

    public void setVisibleButtons(int visibleButtons) {
        this._visibleButtons = visibleButtons;
        this.removeAll();
        this.installComponents();
        this.revalidate();
        this.repaint();
    }

    public boolean isCompact() {
        return this._compact;
    }

    public void setCompact(boolean compact) {
        this._compact = compact;
        this._findNextButton.setText(this._compact ? "" : this.getResourceString("SearchableBar.findNext"));
        this._highlightsButton.setText(this._compact ? "" : this.getResourceString("SearchableBar.highlights"));
        this._findPrevButton.setText(this._compact ? "" : this.getResourceString("SearchableBar.findPrevious"));
    }

    protected ImageIcon getImageIcon(String name) {
        return SearchableBarIconsFactory.getImageIcon(name);
    }

    protected String getResourceString(String key) {
        return Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    public static interface Installer {
        public void openSearchBar(SearchableBar var1);

        public void closeSearchBar(SearchableBar var1);
    }
}

