/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache();
    private String _text = null;

    public TextComponentSearchable(JTextComponent textComponent) {
        super(textComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public void uninstallHighlightsRemover() {
        this._component.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        AbstractAction highlightRemover = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TextComponentSearchable.this.removeAllHighlights();
            }
        };
        this._component.registerKeyboardAction(highlightRemover, KeyStroke.getKeyStroke(27, 0), 0);
    }

    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    protected void setSelectedIndex(int index, boolean incremental) {
        if (this._component instanceof JTextComponent) {
            if (index == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!incremental) {
                this.removeAllHighlights();
            }
            String text = this.getSearchingText();
            try {
                this.addHighlight(index, text, incremental);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addHighlight(int index, String text, boolean incremental) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)this._component;
            Object obj = textComponent.getHighlighter().addHighlight(index, index + text.length(), this._highlightPainter);
            this._highlighCache.addHighlight(obj);
            this._selectedIndex = index;
            if (!incremental) {
                this.scrollTextVisible(textComponent, index, text.length());
            }
        }
    }

    private void scrollTextVisible(JTextComponent textComponent, int index, int length) {
        if (index != -1) {
            try {
                Rectangle begin = textComponent.modelToView(index);
                if (begin == null) {
                    return;
                }
                Rectangle end = textComponent.modelToView(index + length);
                if (end == null) {
                    return;
                }
                Rectangle bounds = this._component.getVisibleRect();
                if (begin.x <= bounds.width) {
                    begin.width = end.x;
                    begin.x = 0;
                } else {
                    begin.width = end.x - begin.x;
                }
                textComponent.scrollRectToVisible(begin);
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator itor = this._highlighCache.getAllHighlights();
            while (itor.hasNext()) {
                Object o = itor.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(o);
            }
            this._highlighCache.removeAllHighlights();
        }
    }

    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    protected Object getElementAt(int index) {
        String text = this.getSearchingText();
        if (text != null && this._component instanceof JTextComponent) {
            int elementCount;
            int endIndex = index + text.length();
            if (endIndex > (elementCount = this.getElementCount())) {
                endIndex = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(index, endIndex - index + 1);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        return "";
    }

    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.hidePopup();
        this._text = null;
        if (evt.getOldValue() instanceof Document) {
            ((Document)evt.getNewValue()).removeDocumentListener(this);
        }
        if (evt.getNewValue() instanceof Document) {
            ((Document)evt.getNewValue()).addDocumentListener(this);
        }
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void insertUpdate(DocumentEvent e) {
        this.hidePopup();
        this._text = null;
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void removeUpdate(DocumentEvent e) {
        this.hidePopup();
        this._text = null;
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void changedUpdate(DocumentEvent e) {
        this.hidePopup();
        this._text = null;
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    protected boolean isActivateKey(KeyEvent e) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return e.getID() == 401 && e.getKeyCode() == 70 && (2 & e.getModifiers()) != 0;
        }
        return super.isActivateKey(e);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color highlightColor) {
        this._highlightColor = highlightColor;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    public int findLast(String s) {
        if (this._component instanceof JTextComponent) {
            String text = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text.lastIndexOf(s);
            }
            return text.toLowerCase().lastIndexOf(s.toLowerCase());
        }
        return super.findLast(s);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String text;
                this._text = text = document.getText(0, document.getLength());
            }
            catch (BadLocationException e) {
                return "";
            }
        }
        return this._text;
    }

    public int findFirst(String s) {
        if (this._component instanceof JTextComponent) {
            String text = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return text.indexOf(s);
            }
            return text.toLowerCase().indexOf(s.toLowerCase());
        }
        return super.findFirst(s);
    }

    public int findFromCursor(String s) {
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(s);
        }
        if (this._component instanceof JTextComponent) {
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                text = text.toLowerCase();
            }
            String str = this.isCaseSensitive() ? s : s.toLowerCase();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int found = text.indexOf(str, selectedIndex);
            if (found == -1 && (found = text.indexOf(str, 0)) >= selectedIndex) {
                found = -1;
            }
            return found;
        }
        return super.findFromCursor(s);
    }

    public int reverseFindFromCursor(String s) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(s);
        }
        if (this._component instanceof JTextComponent) {
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                text = text.toLowerCase();
            }
            String str = this.isCaseSensitive() ? s : s.toLowerCase();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int found = text.lastIndexOf(str, selectedIndex);
            if (found == -1 && (found = text.lastIndexOf(str, text.length() - 1)) <= selectedIndex) {
                found = -1;
            }
            return found;
        }
        return super.findFromCursor(s);
    }

    public int findNext(String s) {
        if (this._component instanceof JTextComponent) {
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                text = text.toLowerCase();
            }
            String str = this.isCaseSensitive() ? s : s.toLowerCase();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int found = text.indexOf(str, selectedIndex + 1);
            if (found == -1 && this.isRepeats() && (found = text.indexOf(str, 0)) >= selectedIndex) {
                found = -1;
            }
            return found;
        }
        return super.findNext(s);
    }

    public int findPrevious(String s) {
        if (this._component instanceof JTextComponent) {
            int count;
            int selectedIndex;
            String text = this.getDocumentText();
            if (!this.isCaseSensitive()) {
                text = text.toLowerCase();
            }
            String str = this.isCaseSensitive() ? s : s.toLowerCase();
            int n = selectedIndex = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if ((count = this.getElementCount()) == 0) {
                return s.length() > 0 ? -1 : 0;
            }
            int found = text.lastIndexOf(str, selectedIndex - 1);
            if (found == -1 && this.isRepeats() && (found = text.lastIndexOf(str, count - 1)) <= selectedIndex) {
                found = -1;
            }
            return found;
        }
        return super.findPrevious(s);
    }

    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    private class HighlighCache
    extends HashMap {
        private HighlighCache() {
        }

        public void addHighlight(Object obj) {
            this.put(obj, null);
        }

        public void removeHighlight(Object obj) {
            this.remove(obj);
        }

        public Iterator getAllHighlights() {
            return this.keySet().iterator();
        }

        public void removeAllHighlights() {
            this.clear();
        }
    }
}

