/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.diff;

import java.util.HashMap;
import java.util.Map;

public class Diff {
    private static int SNAKE_LIMIT = 20;
    private int equiv_max = 1;
    public boolean speed_large_files = false;
    private int[] xvec;
    private int[] yvec;
    private int[] fdiag;
    private int[] bdiag;
    private int fdiagoff;
    private int bdiagoff;
    private final file_data[] filevec = new file_data[2];
    private int cost;
    private int too_expensive = 100;
    private boolean minimal = true;

    public Diff(Object[] a, Object[] b) {
        HashMap h = new HashMap(a.length + b.length);
        this.filevec[0] = new file_data(a, h);
        this.filevec[1] = new file_data(b, h);
    }

    private void diag(int xoff, int xlim, int yoff, int ylim, boolean find_minimal, Partition part) {
        int dmin = xoff - ylim;
        int dmax = xlim - yoff;
        int fmid = xoff - yoff;
        int bmid = xlim - ylim;
        int fmin = fmid;
        int fmax = fmid;
        int bmin = bmid;
        int bmax = bmid;
        boolean odd = (fmid - bmid & 1) != 0;
        this.fdiag[this.fdiagoff + fmid] = xoff;
        this.bdiag[this.bdiagoff + bmid] = xlim;
        int c = 1;
        while (true) {
            int y;
            int oldx;
            int x;
            int thi;
            int tlo;
            int d;
            boolean big_snake = false;
            if (fmin > dmin) {
                this.fdiag[this.fdiagoff + --fmin - 1] = -1;
            } else {
                ++fmin;
            }
            if (fmax < dmax) {
                this.fdiag[this.fdiagoff + ++fmax + 1] = -1;
            } else {
                --fmax;
            }
            for (d = fmax; d >= fmin; d -= 2) {
                tlo = this.fdiag[this.fdiagoff + d - 1];
                thi = this.fdiag[this.fdiagoff + d + 1];
                x = tlo >= thi ? tlo + 1 : thi;
                oldx = x;
                for (y = x - d; x < xlim && y < ylim && this.xvec[x] == this.yvec[y]; ++x, ++y) {
                }
                if (x - oldx > SNAKE_LIMIT) {
                    big_snake = true;
                }
                this.fdiag[this.fdiagoff + d] = x;
                if (!odd || bmin > d || d > bmax || this.bdiag[this.bdiagoff + d] > this.fdiag[this.fdiagoff + d]) continue;
                part.xmid = x;
                part.ymid = y;
                part.lo_minimal = true;
                part.hi_minimal = true;
                return;
            }
            if (bmin > dmin) {
                this.bdiag[this.bdiagoff + --bmin - 1] = Integer.MAX_VALUE;
            } else {
                ++bmin;
            }
            if (bmax < dmax) {
                this.bdiag[this.bdiagoff + ++bmax + 1] = Integer.MAX_VALUE;
            } else {
                --bmax;
            }
            for (d = bmax; d >= bmin; d -= 2) {
                tlo = this.bdiag[this.bdiagoff + d - 1];
                thi = this.bdiag[this.bdiagoff + d + 1];
                x = tlo < thi ? tlo : thi - 1;
                oldx = x;
                for (y = x - d; x > xoff && y > yoff && this.xvec[x - 1] == this.yvec[y - 1]; --x, --y) {
                }
                if (oldx - x > SNAKE_LIMIT) {
                    big_snake = true;
                }
                this.bdiag[this.bdiagoff + d] = x;
                if (odd || fmin > d || d > fmax || x > this.fdiag[this.fdiagoff + d]) continue;
                part.xmid = x;
                part.ymid = y;
                part.lo_minimal = true;
                part.hi_minimal = true;
                return;
            }
            if (!find_minimal) {
                if (c > 200 && big_snake && this.speed_large_files) {
                    int k;
                    int v;
                    int y2;
                    int x2;
                    int dd;
                    int best = 0;
                    block5: for (d = fmax; d >= fmin; d -= 2) {
                        dd = d - fmid;
                        x2 = this.fdiag[this.fdiagoff + d];
                        y2 = x2 - d;
                        v = (x2 - xoff) * 2 - dd;
                        if (v <= 12 * (c + (dd < 0 ? -dd : dd)) || v <= best || xoff + SNAKE_LIMIT > x2 || x2 >= xlim || yoff + SNAKE_LIMIT > y2 || y2 >= ylim) continue;
                        k = 1;
                        while (this.xvec[x2 - k] == this.yvec[y2 - k]) {
                            if (k == SNAKE_LIMIT) {
                                best = v;
                                part.xmid = x2;
                                part.ymid = y2;
                                continue block5;
                            }
                            ++k;
                        }
                    }
                    if (best > 0) {
                        part.lo_minimal = true;
                        part.hi_minimal = false;
                        return;
                    }
                    best = 0;
                    block7: for (d = bmax; d >= bmin; d -= 2) {
                        dd = d - bmid;
                        x2 = this.bdiag[this.bdiagoff + d];
                        y2 = x2 - d;
                        v = (xlim - x2) * 2 + dd;
                        if (v <= 12 * (c + (dd < 0 ? -dd : dd)) || v <= best || xoff >= x2 || x2 > xlim - SNAKE_LIMIT || yoff >= y2 || y2 > ylim - SNAKE_LIMIT) continue;
                        k = 0;
                        while (this.xvec[x2 + k] == this.yvec[y2 + k]) {
                            if (k == SNAKE_LIMIT - 1) {
                                best = v;
                                part.xmid = x2;
                                part.ymid = y2;
                                continue block7;
                            }
                            ++k;
                        }
                    }
                    if (best > 0) {
                        part.lo_minimal = false;
                        part.hi_minimal = true;
                        return;
                    }
                }
                if (c >= this.too_expensive) {
                    int y3;
                    int x3;
                    int fxbest = 0;
                    int bxbest = 0;
                    int fxybest = -1;
                    for (d = fmax; d >= fmin; d -= 2) {
                        x3 = Math.min(this.fdiag[d], xlim);
                        y3 = x3 - d;
                        if (ylim < y3) {
                            x3 = ylim + d;
                            y3 = ylim;
                        }
                        if (fxybest >= x3 + y3) continue;
                        fxybest = x3 + y3;
                        fxbest = x3;
                    }
                    int bxybest = Integer.MAX_VALUE;
                    for (d = bmax; d >= bmin; d -= 2) {
                        x3 = Math.max(xoff, this.bdiag[d]);
                        y3 = x3 - d;
                        if (y3 < yoff) {
                            x3 = yoff + d;
                            y3 = yoff;
                        }
                        if (x3 + y3 >= bxybest) continue;
                        bxybest = x3 + y3;
                        bxbest = x3;
                    }
                    if (xlim + ylim - bxybest < fxybest - (xoff + yoff)) {
                        part.xmid = fxbest;
                        part.ymid = fxybest - fxbest;
                        part.lo_minimal = true;
                        part.hi_minimal = false;
                    } else {
                        part.xmid = bxbest;
                        part.ymid = bxybest - bxbest;
                        part.lo_minimal = false;
                        part.hi_minimal = true;
                    }
                    return;
                }
            }
            ++c;
        }
    }

    private void compareseq(int xoff, int xlim, int yoff, int ylim, boolean find_minimal) {
        while (xoff < xlim && yoff < ylim && this.xvec[xoff] == this.yvec[yoff]) {
            ++xoff;
            ++yoff;
        }
        while (xlim > xoff && ylim > yoff && this.xvec[xlim - 1] == this.yvec[ylim - 1]) {
            --xlim;
            --ylim;
        }
        if (xoff == xlim) {
            while (yoff < ylim) {
                this.filevec[1].changed_flag[1 + this.filevec[1].realindexes[yoff++]] = true;
            }
        } else if (yoff == ylim) {
            while (xoff < xlim) {
                this.filevec[0].changed_flag[1 + this.filevec[0].realindexes[xoff++]] = true;
            }
        } else {
            Partition part = new Partition();
            this.diag(xoff, xlim, yoff, ylim, find_minimal, part);
            this.compareseq(xoff, part.xmid, yoff, part.ymid, part.lo_minimal);
            this.compareseq(part.xmid, xlim, part.ymid, ylim, part.hi_minimal);
        }
    }

    private void discard_confusing_lines() {
        this.filevec[0].discard_confusing_lines(this.filevec[1]);
        this.filevec[1].discard_confusing_lines(this.filevec[0]);
    }

    private void shift_boundaries() {
        this.filevec[0].shift_boundaries(this.filevec[1]);
        this.filevec[1].shift_boundaries(this.filevec[0]);
    }

    private change build_script() {
        change script = null;
        boolean[] changed0 = this.filevec[0].changed_flag;
        boolean[] changed1 = this.filevec[1].changed_flag;
        int len0 = this.filevec[0].buffered_lines;
        int len1 = this.filevec[1].buffered_lines;
        int i0 = len0;
        for (int i1 = len1; i0 >= 0 || i1 >= 0; --i0, --i1) {
            if (!changed0[i0] && !changed1[i1]) continue;
            int line0 = i0;
            int line1 = i1;
            while (changed0[i0]) {
                --i0;
            }
            while (changed1[i1]) {
                --i1;
            }
            script = new change(i0, i1, line0 - i0, line1 - i1, script);
        }
        return script;
    }

    public change diff_2() {
        long time = System.currentTimeMillis();
        this.discard_confusing_lines();
        this.xvec = this.filevec[0].undiscarded;
        this.yvec = this.filevec[1].undiscarded;
        int diags = this.filevec[0].nondiscarded_lines + this.filevec[1].nondiscarded_lines + 3;
        this.fdiag = new int[diags];
        this.fdiagoff = this.filevec[1].nondiscarded_lines + 1;
        this.bdiag = new int[diags];
        this.bdiagoff = this.filevec[1].nondiscarded_lines + 1;
        this.compareseq(0, this.filevec[0].nondiscarded_lines, 0, this.filevec[1].nondiscarded_lines, this.minimal);
        this.fdiag = null;
        this.bdiag = null;
        this.shift_boundaries();
        return this.build_script();
    }

    class Partition {
        int xmid;
        int ymid;
        boolean lo_minimal;
        boolean hi_minimal;

        Partition() {
        }
    }

    class file_data {
        final int buffered_lines;
        private final int[] equivs;
        final int[] undiscarded;
        final int[] realindexes;
        int nondiscarded_lines;
        boolean[] changed_flag;

        void clear() {
            this.changed_flag = new boolean[this.buffered_lines + 2];
        }

        int[] equivCount() {
            int[] equiv_count = new int[Diff.this.equiv_max];
            for (int i = 0; i < this.buffered_lines; ++i) {
                int n = this.equivs[i];
                equiv_count[n] = equiv_count[n] + 1;
            }
            return equiv_count;
        }

        void discard_confusing_lines(file_data f) {
            this.clear();
            byte[] discarded = this.discardable(f.equivCount());
            this.filterDiscards(discarded);
            this.discard(discarded);
        }

        private byte[] discardable(int[] counts) {
            int end = this.buffered_lines;
            byte[] discards = new byte[end];
            int[] equivs = this.equivs;
            int many = 5;
            int tem = end / 64;
            while ((tem >>= 2) > 0) {
                many *= 2;
            }
            for (int i = 0; i < end; ++i) {
                if (equivs[i] == 0) continue;
                int nmatch = counts[equivs[i]];
                if (nmatch == 0) {
                    discards[i] = 1;
                    continue;
                }
                if (nmatch <= many) continue;
                discards[i] = 2;
            }
            return discards;
        }

        private void filterDiscards(byte[] discards) {
            int end = this.buffered_lines;
            block0: for (int i = 0; i < end; ++i) {
                int j;
                if (discards[i] == 2) {
                    discards[i] = 0;
                    continue;
                }
                if (discards[i] == 0) continue;
                int provisional = 0;
                for (j = i; j < end && discards[j] != 0; ++j) {
                    if (discards[j] != 2) continue;
                    ++provisional;
                }
                while (j > i && discards[j - 1] == 2) {
                    discards[--j] = 0;
                    --provisional;
                }
                int length = j - i;
                if (provisional * 4 > length) {
                    while (j > i) {
                        if (discards[--j] != 2) continue;
                        discards[j] = 0;
                    }
                    continue;
                }
                int minimum = 1;
                int tem = length / 4;
                while ((tem >>= 2) > 0) {
                    minimum *= 2;
                }
                ++minimum;
                int consec = 0;
                for (j = 0; j < length; ++j) {
                    if (discards[i + j] != 2) {
                        consec = 0;
                        continue;
                    }
                    if (minimum == ++consec) {
                        j -= consec;
                        continue;
                    }
                    if (minimum >= consec) continue;
                    discards[i + j] = 0;
                }
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i + j] != 1); ++j) {
                    if (discards[i + j] == 2) {
                        consec = 0;
                        discards[i + j] = 0;
                    } else {
                        consec = discards[i + j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) break;
                }
                i += length - 1;
                consec = 0;
                for (j = 0; j < length && (j < 8 || discards[i - j] != 1); ++j) {
                    if (discards[i - j] == 2) {
                        consec = 0;
                        discards[i - j] = 0;
                    } else {
                        consec = discards[i - j] == 0 ? 0 : ++consec;
                    }
                    if (consec == 3) continue block0;
                }
            }
        }

        private void discard(byte[] discards) {
            int end = this.buffered_lines;
            int j = 0;
            for (int i = 0; i < end; ++i) {
                if (Diff.this.minimal || discards[i] == 0) {
                    this.undiscarded[j] = this.equivs[i];
                    this.realindexes[j++] = i;
                    continue;
                }
                this.changed_flag[1 + i] = true;
            }
            this.nondiscarded_lines = j;
        }

        file_data(Object[] data, Map h) {
            this.buffered_lines = data.length;
            this.equivs = new int[this.buffered_lines];
            this.undiscarded = new int[this.buffered_lines];
            this.realindexes = new int[this.buffered_lines];
            for (int i = 0; i < data.length; ++i) {
                Integer ir = (Integer)h.get(data[i]);
                if (ir == null) {
                    this.equivs[i] = Diff.this.equiv_max++;
                    h.put(data[i], new Integer(this.equivs[i]));
                    continue;
                }
                this.equivs[i] = ir;
            }
        }

        void shift_boundaries(file_data f) {
            boolean[] changed = this.changed_flag;
            boolean[] other_changed = f.changed_flag;
            int i = 0;
            int j = 0;
            int i_end = this.buffered_lines;
            int preceding = -1;
            int other_preceding = -1;
            while (true) {
                if (i < i_end && !changed[1 + i]) {
                    while (other_changed[1 + j++]) {
                        other_preceding = j;
                    }
                    ++i;
                    continue;
                }
                if (i == i_end) break;
                int start = i;
                int other_start = j;
                while (true) {
                    if (i < i_end && changed[1 + i]) {
                        ++i;
                        continue;
                    }
                    int end = i;
                    if (end == i_end || this.equivs[start] != this.equivs[end] || other_changed[1 + j] || end == i_end || preceding >= 0 && start == preceding || other_preceding >= 0 && other_start == other_preceding) break;
                    changed[1 + end++] = true;
                    changed[1 + start++] = false;
                    ++i;
                    ++j;
                }
                preceding = i;
                other_preceding = j;
            }
        }
    }

    public static class change {
        public change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        change(int line0, int line1, int deleted, int inserted, change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        public void print() {
            System.out.println(this);
            if (this.link != null) {
                this.link.print();
            }
        }

        public String toString() {
            return "line0=" + this.line0 + ", line1=" + this.line1 + ", inserted=" + this.inserted + ", deleted=" + this.deleted;
        }
    }
}

