/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingworker.SwingWorker;
import org.jmeld.Version;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.Filter;
import org.jmeld.ui.AbstractBarDialog;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FolderDiffPanel;
import org.jmeld.ui.NewPanelDialog;
import org.jmeld.ui.StatusBar;
import org.jmeld.ui.VersionControlPanel;
import org.jmeld.ui.action.ActionHandler;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.bar.LineNumberBarDialog;
import org.jmeld.ui.search.SearchBarDialog;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.settings.SettingsPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.SwingUtil;
import org.jmeld.ui.util.TabIcon;
import org.jmeld.ui.util.ToolBarBuilder;
import org.jmeld.ui.util.WidgetFactory;
import org.jmeld.util.ObjectUtil;
import org.jmeld.util.StringUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.file.DirectoryDiff;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.file.VersionControlDiff;
import org.jmeld.util.node.JMDiffNode;
import org.jmeld.util.node.JMDiffNodeFactory;
import org.jmeld.vc.VersionControlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeldPanel
extends JPanel
implements ConfigurationListenerIF {
    private static final String NEW_ACTION = "New";
    private static final String SAVE_ACTION = "Save";
    private static final String UNDO_ACTION = "Undo";
    private static final String REDO_ACTION = "Redo";
    private static final String RIGHT_ACTION = "Right";
    private static final String LEFT_ACTION = "Left";
    private static final String UP_ACTION = "Up";
    private static final String DOWN_ACTION = "Down";
    private static final String ZOOMPLUS_ACTION = "ZoomPlus";
    private static final String ZOOMMIN_ACTION = "ZoomMin";
    private static final String GOTOSELECTED_ACTION = "GoToSelected";
    private static final String GOTOFIRST_ACTION = "GoToFirst";
    private static final String GOTOLAST_ACTION = "GoToLast";
    private static final String GOTOLINE_ACTION = "GoToLine";
    private static final String STARTSEARCH_ACTION = "StartSearch";
    private static final String NEXTSEARCH_ACTION = "NextSearch";
    private static final String PREVIOUSSEARCH_ACTION = "PreviousSearch";
    private static final String REFRESH_ACTION = "Refresh";
    private static final String MERGEMODE_ACTION = "MergeMode";
    private static final String HELP_ACTION = "Help";
    private static final String ABOUT_ACTION = "About";
    private static final String SETTINGS_ACTION = "Settings";
    private static final String EXIT_ACTION = "Exit";
    public final Option SHOW_TOOLBAR_OPTION = new Option(true);
    public final Option SHOW_TABBEDPANE_OPTION = new Option(true);
    private ActionHandler actionHandler;
    private JideTabbedPane tabbedPane;
    private JPanel barContainer;
    private AbstractBarDialog currentBarDialog;
    private SearchBarDialog searchBarDialog;
    private JComponent toolBar;
    private boolean mergeMode;
    private boolean started;

    public JMeldPanel() {
        this.setFocusable(true);
        this.addAncestorListener(this.getAncestorListener());
    }

    private void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.tabbedPane = new JideTabbedPane();
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.setShowCloseButtonOnTab(true);
        this.tabbedPane.setShowCloseButtonOnSelectedTab(true);
        if (!this.SHOW_TABBEDPANE_OPTION.isEnabled()) {
            this.tabbedPane.setShowTabArea(false);
        }
        this.tabbedPane.setTabShape(4);
        this.initActions();
        this.tabbedPane.setCloseAction(this.actionHandler.get(EXIT_ACTION));
        this.setLayout(new BorderLayout());
        this.addToolBar();
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.getBar(), "Last");
        this.tabbedPane.getModel().addChangeListener(this.getChangeListener());
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    public void openComparison(List<String> fileNameList) {
        if (fileNameList.size() <= 0) {
            return;
        }
        if (fileNameList.size() > 1) {
            if (new File(fileNameList.get(0)).isDirectory()) {
                String fileName1 = fileNameList.get(0);
                for (int i = 1; i < fileNameList.size(); ++i) {
                    String fileName2 = fileNameList.get(i);
                    this.openComparison(fileName1, fileName2);
                }
            } else {
                for (int i = 0; i < fileNameList.size(); i += 2) {
                    String fileName1 = fileNameList.get(i);
                    if (i + 1 >= fileNameList.size()) continue;
                    String fileName2 = fileNameList.get(i + 1);
                    this.openComparison(fileName1, fileName2);
                }
            }
        } else {
            this.openComparison(fileNameList.get(0), null);
        }
    }

    public void openComparison(String leftName, String rightName) {
        File file;
        if (!StringUtil.isEmpty(leftName) && !StringUtil.isEmpty(rightName)) {
            File leftFile = new File(leftName);
            File rightFile = new File(rightName);
            if (leftFile.isDirectory()) {
                if (rightFile.isDirectory()) {
                    this.openDirectoryComparison(leftFile, rightFile, JMeldSettings.getInstance().getFilter().getFilter("default"));
                } else {
                    this.openFileComparison(new File(leftFile, rightName), rightFile, false);
                }
            } else {
                this.openFileComparison(leftFile, rightFile, false);
            }
        } else if (!StringUtil.isEmpty(leftName) && (file = new File(leftName)).exists() && VersionControlUtil.isVersionControlled(file)) {
            this.openVersionControlComparison(file);
        }
    }

    public void openFileComparison(File leftFile, File rightFile, boolean openInBackground) {
        new NewFileComparisonPanel(leftFile, rightFile, openInBackground).execute();
    }

    public void openFileComparison(JMDiffNode diffNode, boolean openInBackground) {
        new NewFileComparisonPanel(diffNode, openInBackground).execute();
    }

    public void openDirectoryComparison(File leftFile, File rightFile, Filter filter) {
        new NewDirectoryComparisonPanel(leftFile, rightFile, filter).execute();
    }

    public void openVersionControlComparison(File directory) {
        new NewVersionControlComparisonPanel(directory).execute();
    }

    public void addToolBar() {
        if (this.SHOW_TOOLBAR_OPTION.isEnabled()) {
            if (this.toolBar != null) {
                this.remove(this.toolBar);
            }
            this.toolBar = this.getToolBar();
            this.add((Component)this.toolBar, "First");
            this.revalidate();
        }
    }

    private JComponent getToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.setRollover(true);
        ToolBarBuilder builder = new ToolBarBuilder(tb);
        JButton button = WidgetFactory.getToolBarButton(this.actionHandler.get(NEW_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(SAVE_ACTION));
        builder.addButton(button);
        builder.addSeparator();
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(UNDO_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(REDO_ACTION));
        builder.addButton(button);
        builder.addSpring();
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(SETTINGS_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(HELP_ACTION));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.actionHandler.get(ABOUT_ACTION));
        builder.addButton(button);
        return tb;
    }

    private JComponent getBar() {
        CellConstraints cc = new CellConstraints();
        this.barContainer = new JPanel(new FormLayout("0:grow", "pref, pref, pref"));
        this.barContainer.add((Component)new JSeparator(), cc.xy(1, 2));
        this.barContainer.add((Component)StatusBar.getInstance(), cc.xy(1, 3));
        return this.barContainer;
    }

    private SearchBarDialog getSearchBarDialog() {
        if (this.searchBarDialog == null) {
            this.searchBarDialog = new SearchBarDialog(this);
        }
        return this.searchBarDialog;
    }

    public void initActions() {
        this.actionHandler = new ActionHandler();
        MeldAction action = this.actionHandler.createAction(this, NEW_ACTION);
        action.setIcon("stock_new");
        action.setToolTip("Merge 2 new files");
        action = this.actionHandler.createAction(this, SAVE_ACTION);
        action.setIcon("stock_save");
        action.setToolTip("Save the changed files");
        this.installKey("ctrl S", action);
        action = this.actionHandler.createAction(this, UNDO_ACTION);
        action.setIcon("stock_undo");
        action.setToolTip("Undo the latest change");
        this.installKey("control Z", action);
        this.installKey("control Y", action);
        action = this.actionHandler.createAction(this, REDO_ACTION);
        action.setIcon("stock_redo");
        action.setToolTip("Redo the latest change");
        this.installKey("control R", action);
        action = this.actionHandler.createAction(this, LEFT_ACTION);
        this.installKey("LEFT", action);
        this.installKey("alt LEFT", action);
        this.installKey("alt KP_LEFT", action);
        action = this.actionHandler.createAction(this, RIGHT_ACTION);
        this.installKey("RIGHT", action);
        this.installKey("alt RIGHT", action);
        this.installKey("alt KP_RIGHT", action);
        action = this.actionHandler.createAction(this, UP_ACTION);
        this.installKey("UP", action);
        this.installKey("alt UP", action);
        this.installKey("alt KP_UP", action);
        this.installKey("F7", action);
        action = this.actionHandler.createAction(this, DOWN_ACTION);
        this.installKey("DOWN", action);
        this.installKey("alt DOWN", action);
        this.installKey("alt KP_DOWN", action);
        this.installKey("F8", action);
        action = this.actionHandler.createAction(this, ZOOMPLUS_ACTION);
        this.installKey("alt EQUALS", action);
        this.installKey("shift alt EQUALS", action);
        this.installKey("alt ADD", action);
        action = this.actionHandler.createAction(this, ZOOMMIN_ACTION);
        this.installKey("alt MINUS", action);
        this.installKey("shift alt MINUS", action);
        this.installKey("alt SUBTRACT", action);
        action = this.actionHandler.createAction(this, GOTOSELECTED_ACTION);
        this.installKey("alt ENTER", action);
        action = this.actionHandler.createAction(this, GOTOFIRST_ACTION);
        this.installKey("alt HOME", action);
        action = this.actionHandler.createAction(this, GOTOLAST_ACTION);
        this.installKey("alt END", action);
        action = this.actionHandler.createAction(this, GOTOLINE_ACTION);
        this.installKey("ctrl L", action);
        action = this.actionHandler.createAction(this, STARTSEARCH_ACTION);
        this.installKey("ctrl F", action);
        action = this.actionHandler.createAction(this, NEXTSEARCH_ACTION);
        this.installKey("F3", action);
        this.installKey("ctrl G", action);
        action = this.actionHandler.createAction(this, PREVIOUSSEARCH_ACTION);
        this.installKey("shift F3", action);
        action = this.actionHandler.createAction(this, REFRESH_ACTION);
        this.installKey("F5", action);
        action = this.actionHandler.createAction(this, MERGEMODE_ACTION);
        this.installKey("F9", action);
        action = this.actionHandler.createAction(this, HELP_ACTION);
        action.setIcon("stock_help-agent");
        this.installKey("F1", action);
        action = this.actionHandler.createAction(this, ABOUT_ACTION);
        action.setIcon("stock_about");
        action = this.actionHandler.createAction(this, SETTINGS_ACTION);
        action.setIcon("stock_preferences");
        action.setToolTip(SETTINGS_ACTION);
        action = this.actionHandler.createAction(this, EXIT_ACTION);
        this.installKey("ESCAPE", action);
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void checkActions() {
        if (this.actionHandler != null) {
            this.actionHandler.checkActions();
        }
    }

    public void doNew(ActionEvent ae) {
        NewPanelDialog dialog = new NewPanelDialog(this);
        dialog.show();
        if (dialog.getFunction() == NewPanelDialog.Function.FILE_COMPARISON) {
            this.openFileComparison(new File(dialog.getLeftFileName()), new File(dialog.getRightFileName()), false);
        } else if (dialog.getFunction() == NewPanelDialog.Function.DIRECTORY_COMPARISON) {
            this.openDirectoryComparison(new File(dialog.getLeftDirectoryName()), new File(dialog.getRightDirectoryName()), dialog.getFilter());
        } else if (dialog.getFunction() == NewPanelDialog.Function.VERSION_CONTROL) {
            this.openVersionControlComparison(new File(dialog.getVersionControlDirectoryName()));
        }
    }

    public void doSave(ActionEvent ae) {
        this.getCurrentContentPanel().doSave();
    }

    public boolean isSaveEnabled() {
        AbstractContentPanel panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isSaveEnabled();
    }

    public void doUndo(ActionEvent ae) {
        this.getCurrentContentPanel().doUndo();
    }

    public boolean isUndoEnabled() {
        AbstractContentPanel panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isUndoEnabled();
    }

    public void doRedo(ActionEvent ae) {
        this.getCurrentContentPanel().doRedo();
    }

    public boolean isRedoEnabled() {
        AbstractContentPanel panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isRedoEnabled();
    }

    public void doLeft(ActionEvent ae) {
        this.getCurrentContentPanel().doLeft();
        this.repaint();
    }

    public void doRight(ActionEvent ae) {
        this.getCurrentContentPanel().doRight();
        this.repaint();
    }

    public void doUp(ActionEvent ae) {
        this.getCurrentContentPanel().doUp();
        this.repaint();
    }

    public void doDown(ActionEvent ae) {
        this.getCurrentContentPanel().doDown();
        this.repaint();
    }

    public void doZoomPlus(ActionEvent ae) {
        this.getCurrentContentPanel().doZoom(true);
        this.repaint();
    }

    public void doZoomMin(ActionEvent ae) {
        this.getCurrentContentPanel().doZoom(false);
        this.repaint();
    }

    public void doGoToSelected(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToSelected();
        this.repaint();
    }

    public void doGoToFirst(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToFirst();
        this.repaint();
    }

    public void doGoToLast(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToLast();
        this.repaint();
    }

    public void doGoToLine(ActionEvent ae) {
        this.activateBarDialog(new LineNumberBarDialog(this));
    }

    public void doGoToLine(int line) {
        this.getCurrentContentPanel().doGoToLine(line);
        this.repaint();
        this.deactivateBarDialog();
    }

    public void doStartSearch(ActionEvent ae) {
        SearchBarDialog sbd = this.getSearchBarDialog();
        sbd.setSearchText(this.getSelectedSearchText());
        this.activateBarDialog(sbd);
    }

    public void doStopSearch(ActionEvent ae) {
        this.deactivateBarDialog();
        for (AbstractContentPanel cp : this.getContentPanelList()) {
            cp.doStopSearch();
        }
    }

    public SearchHits doSearch(ActionEvent ae) {
        return this.getCurrentContentPanel().doSearch();
    }

    SearchCommand getSearchCommand() {
        if (this.currentBarDialog != this.getSearchBarDialog()) {
            return null;
        }
        return this.getSearchBarDialog().getCommand();
    }

    public void doNextSearch(ActionEvent ae) {
        if (this.currentBarDialog != this.getSearchBarDialog()) {
            return;
        }
        this.getCurrentContentPanel().doNextSearch();
    }

    public void doPreviousSearch(ActionEvent ae) {
        if (this.currentBarDialog != this.getSearchBarDialog()) {
            return;
        }
        this.getCurrentContentPanel().doPreviousSearch();
    }

    private String getSelectedSearchText() {
        return this.getCurrentContentPanel().getSelectedText();
    }

    public void doRefresh(ActionEvent ae) {
        this.getCurrentContentPanel().doRefresh();
    }

    public void doMergeMode(ActionEvent ae) {
        this.mergeMode = !this.mergeMode;
        MeldAction action = this.actionHandler.get(LEFT_ACTION);
        this.installKey(this.mergeMode, "LEFT", action);
        action = this.actionHandler.get(RIGHT_ACTION);
        this.installKey(this.mergeMode, "RIGHT", action);
        action = this.actionHandler.get(UP_ACTION);
        this.installKey(this.mergeMode, "UP", action);
        action = this.actionHandler.get(DOWN_ACTION);
        this.installKey(this.mergeMode, "DOWN", action);
        this.getCurrentContentPanel().doMergeMode(this.mergeMode);
        this.requestFocus();
        if (this.mergeMode) {
            StatusBar.getInstance().setNotification(MERGEMODE_ACTION, ImageUtil.getSmallImageIcon("jmeld_mergemode-on"));
        } else {
            StatusBar.getInstance().removeNotification(MERGEMODE_ACTION);
        }
    }

    public void doHelp(ActionEvent ae) {
        try {
            String contentId = "HelpPanel";
            if (this.checkAlreadyOpen(contentId)) {
                return;
            }
            URL url = HelpSet.findHelpSet(this.getClass().getClassLoader(), "jmeld");
            HelpSet helpSet = new HelpSet(this.getClass().getClassLoader(), url);
            JHelpContentViewer viewer = new JHelpContentViewer(helpSet);
            NavigatorView navigatorView = helpSet.getNavigatorView("TOC");
            JHelpNavigator navigator = (JHelpNavigator)navigatorView.createNavigator(viewer.getModel());
            JSplitPane splitPane = new JSplitPane();
            splitPane.setLeftComponent(navigator);
            splitPane.setRightComponent(viewer);
            AbstractContentPanel content = new AbstractContentPanel();
            content.setId(contentId);
            content.setLayout(new BorderLayout());
            content.add((Component)splitPane, "Center");
            this.tabbedPane.addTab(HELP_ACTION, ImageUtil.getSmallImageIcon("stock_help-agent"), content);
            this.tabbedPane.setSelectedComponent(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doAbout(ActionEvent ae) {
        String contentId = "AboutPanel";
        if (this.checkAlreadyOpen(contentId)) {
            return;
        }
        AbstractContentPanel content = new AbstractContentPanel();
        content.setId(contentId);
        content.setLayout(new BorderLayout());
        content.add((Component)new JButton("JMeld version: " + Version.getVersion()), "Center");
        this.tabbedPane.addTab(ABOUT_ACTION, ImageUtil.getSmallImageIcon("stock_about"), content);
        this.tabbedPane.setSelectedComponent(content);
    }

    public void doExit(ActionEvent ae) {
        if (this.currentBarDialog == this.getSearchBarDialog()) {
            this.doStopSearch(ae);
            return;
        }
        if (this.currentBarDialog != null) {
            this.deactivateBarDialog();
            return;
        }
        AbstractContentPanel cp = this.getCurrentContentPanel();
        if (cp == null) {
            return;
        }
        if (ae.getSource() == this && !cp.checkExit()) {
            return;
        }
        this.doExitTab(this.getCurrentContentPanel());
    }

    public void doSettings(ActionEvent ae) {
        String contentId = "SettingsPanel";
        if (this.checkAlreadyOpen(contentId)) {
            return;
        }
        SettingsPanel content = new SettingsPanel(this);
        content.setId(contentId);
        this.tabbedPane.addTab(SETTINGS_ACTION, ImageUtil.getSmallImageIcon("stock_preferences"), content);
        this.tabbedPane.setSelectedComponent(content);
    }

    private boolean checkAlreadyOpen(String contentId) {
        AbstractContentPanel contentPanel = this.getAlreadyOpen(contentId);
        if (contentPanel != null) {
            this.tabbedPane.setSelectedComponent(contentPanel);
            return true;
        }
        return false;
    }

    private AbstractContentPanel getAlreadyOpen(String contentId) {
        for (AbstractContentPanel contentPanel : this.getContentPanelList()) {
            if (!ObjectUtil.equals(contentPanel.getId(), contentId)) continue;
            System.out.println("already open: " + contentId);
            return contentPanel;
        }
        return null;
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JMeldPanel.this.checkActions();
            }
        };
    }

    public WindowListener getWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                for (AbstractContentPanel contentPanel : JMeldPanel.this.getContentPanelList()) {
                    if (contentPanel.checkSave()) continue;
                    return;
                }
                System.exit(1);
            }
        };
    }

    private AbstractContentPanel getCurrentContentPanel() {
        return (AbstractContentPanel)this.tabbedPane.getSelectedComponent();
    }

    private List<AbstractContentPanel> getContentPanelList() {
        ArrayList<AbstractContentPanel> result = new ArrayList<AbstractContentPanel>();
        if (this.tabbedPane != null) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                result.add((AbstractContentPanel)this.tabbedPane.getComponentAt(i));
            }
        }
        return result;
    }

    private void installKey(boolean enabled, String key, MeldAction action) {
        if (!enabled) {
            this.deInstallKey(key, action);
        } else {
            this.installKey(key, action);
        }
    }

    private void installKey(String key, MeldAction action) {
        SwingUtil.installKey(this, key, action);
    }

    private void deInstallKey(String key, MeldAction action) {
        SwingUtil.deInstallKey(this, key, action);
    }

    private boolean doExitTab(Component component) {
        AbstractContentPanel content;
        if (component == null) {
            return false;
        }
        int index = this.tabbedPane.indexOfComponent(component);
        if (index == -1) {
            return false;
        }
        if (component instanceof AbstractContentPanel && !(content = (AbstractContentPanel)component).checkSave()) {
            return false;
        }
        Icon icon = this.tabbedPane.getIconAt(index);
        if (icon != null && icon instanceof TabIcon) {
            ((TabIcon)icon).exit();
        }
        this.tabbedPane.remove(component);
        return true;
    }

    public void activateBarDialog(AbstractBarDialog bar) {
        this.deactivateBarDialog();
        CellConstraints cc = new CellConstraints();
        this.barContainer.add((Component)bar, cc.xy(1, 1));
        bar.activate();
        this.currentBarDialog = bar;
        this.barContainer.revalidate();
    }

    public void deactivateBarDialog() {
        if (this.currentBarDialog != null) {
            this.barContainer.remove(this.currentBarDialog);
            this.barContainer.revalidate();
            this.currentBarDialog.deactivate();
            this.currentBarDialog = null;
        }
    }

    @Override
    public void configurationChanged() {
        this.checkActions();
    }

    private AncestorListener getAncestorListener() {
        return new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                JMeldPanel.this.start();
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
            }
        };
    }

    public class Option {
        private boolean enabled;

        Option(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void enable() {
            if (JMeldPanel.this.started) {
                System.out.println("Cannot change an option after start!");
                return;
            }
            this.enabled = true;
        }

        public void disable() {
            if (JMeldPanel.this.started) {
                System.out.println("Cannot change an option after start!");
                return;
            }
            this.enabled = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NewVersionControlComparisonPanel
    extends SwingWorker<String, Object> {
        private File directory;
        private VersionControlDiff diff;
        private AbstractContentPanel contentPanel;
        private String contentId;

        NewVersionControlComparisonPanel(File directory) {
            this.directory = directory;
        }

        @Override
        public String doInBackground() {
            if (StringUtil.isEmpty(this.directory.getName())) {
                return "directory is empty";
            }
            if (!this.directory.exists()) {
                return "directory(" + this.directory.getAbsolutePath() + ") doesn't exist";
            }
            if (!this.directory.isDirectory()) {
                return "directoryName(" + this.directory.getName() + ") is not a directory";
            }
            this.contentId = "VersionControlDiffPanel:" + this.directory.getName();
            this.contentPanel = JMeldPanel.this.getAlreadyOpen(this.contentId);
            if (this.contentPanel == null) {
                this.diff = new VersionControlDiff(this.directory, FolderDiff.Mode.TWO_WAY);
                this.diff.diff();
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                String result = (String)this.get();
                if (result != null) {
                    JOptionPane.showMessageDialog(JMeldPanel.this, result, "Error opening file", 0);
                } else if (this.contentPanel != null) {
                    JMeldPanel.this.tabbedPane.setSelectedComponent(this.contentPanel);
                } else {
                    VersionControlPanel panel = new VersionControlPanel(JMeldPanel.this, this.diff);
                    panel.setId(this.contentId);
                    JMeldPanel.this.tabbedPane.addTab("TODO: Think of title!", ImageUtil.getSmallImageIcon("stock_folder"), panel);
                    JMeldPanel.this.tabbedPane.setSelectedComponent(panel);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NewDirectoryComparisonPanel
    extends SwingWorker<String, Object> {
        private File leftFile;
        private File rightFile;
        private Filter filter;
        private DirectoryDiff diff;
        private AbstractContentPanel contentPanel;
        private String contentId;

        NewDirectoryComparisonPanel(File leftFile, File rightFile, Filter filter) {
            this.leftFile = leftFile;
            this.rightFile = rightFile;
            this.filter = filter;
        }

        @Override
        public String doInBackground() {
            if (StringUtil.isEmpty(this.leftFile.getName())) {
                return "left directoryName is empty";
            }
            if (!this.leftFile.exists()) {
                return "left directoryName(" + this.leftFile.getAbsolutePath() + ") doesn't exist";
            }
            if (!this.leftFile.isDirectory()) {
                return "left directoryName(" + this.leftFile.getName() + ") is not a directory";
            }
            if (StringUtil.isEmpty(this.rightFile.getName())) {
                return "right directoryName is empty";
            }
            if (!this.rightFile.exists()) {
                return "right directoryName(" + this.rightFile.getAbsolutePath() + ") doesn't exist";
            }
            if (!this.rightFile.isDirectory()) {
                return "right directoryName(" + this.rightFile.getName() + ") is not a directory";
            }
            this.contentId = "FolderDiffPanel:" + this.leftFile.getName() + "-" + this.rightFile.getName();
            this.contentPanel = JMeldPanel.this.getAlreadyOpen(this.contentId);
            if (this.contentPanel == null) {
                this.diff = new DirectoryDiff(this.leftFile, this.rightFile, this.filter, FolderDiff.Mode.TWO_WAY);
                this.diff.diff();
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                String result = (String)this.get();
                if (result != null) {
                    JOptionPane.showMessageDialog(JMeldPanel.this, result, "Error opening file", 0);
                } else if (this.contentPanel != null) {
                    JMeldPanel.this.tabbedPane.setSelectedComponent(this.contentPanel);
                } else {
                    FolderDiffPanel panel = new FolderDiffPanel(JMeldPanel.this, this.diff);
                    panel.setId(this.contentId);
                    JMeldPanel.this.tabbedPane.addTab(panel.getTitle(), ImageUtil.getSmallImageIcon("stock_folder"), panel);
                    JMeldPanel.this.tabbedPane.setSelectedComponent(panel);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NewFileComparisonPanel
    extends SwingWorker<String, Object> {
        private JMDiffNode diffNode;
        private File leftFile;
        private File rightFile;
        private boolean openInBackground;
        private BufferDiffPanel panel;
        private AbstractContentPanel contentPanel;
        private String contentId;

        NewFileComparisonPanel(JMDiffNode diffNode, boolean openInBackground) {
            this.diffNode = diffNode;
            this.openInBackground = openInBackground;
        }

        NewFileComparisonPanel(File leftFile, File rightFile, boolean openInBackground) {
            this.leftFile = leftFile;
            this.rightFile = rightFile;
            this.openInBackground = openInBackground;
        }

        @Override
        public String doInBackground() {
            try {
                if (this.diffNode == null) {
                    if (StringUtil.isEmpty(this.leftFile.getName())) {
                        return "left filename is empty";
                    }
                    if (!this.leftFile.exists()) {
                        return "left filename(" + this.leftFile.getAbsolutePath() + ") doesn't exist";
                    }
                    if (StringUtil.isEmpty(this.rightFile.getName())) {
                        return "right filename is empty";
                    }
                    if (!this.rightFile.exists()) {
                        return "right filename(" + this.rightFile.getAbsolutePath() + ") doesn't exist";
                    }
                    this.diffNode = JMDiffNodeFactory.create(this.leftFile.getName(), this.leftFile, this.rightFile.getName(), this.rightFile);
                }
                this.contentId = "BufferDiffPanel:" + this.diffNode.getId();
                this.contentPanel = JMeldPanel.this.getAlreadyOpen(this.contentId);
                if (this.contentPanel == null) {
                    this.diffNode.diff();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                String result = (String)this.get();
                if (result != null) {
                    JOptionPane.showMessageDialog(JMeldPanel.this, result, "Error opening file", 0);
                } else if (this.contentPanel != null) {
                    JMeldPanel.this.tabbedPane.setSelectedComponent(this.contentPanel);
                } else {
                    this.panel = new BufferDiffPanel(JMeldPanel.this);
                    this.panel.setId(this.contentId);
                    this.panel.setDiffNode(this.diffNode);
                    JMeldPanel.this.tabbedPane.addTab(this.panel.getTitle(), ImageUtil.getSmallImageIcon("stock_new"), this.panel);
                    if (!this.openInBackground) {
                        JMeldPanel.this.tabbedPane.setSelectedComponent(this.panel);
                    }
                    this.panel.doGoToFirst();
                    this.panel.repaint();
                    SwingUtilities.invokeLater(this.getDoGoToFirst());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private Runnable getDoGoToFirst() {
            return new Runnable(){

                public void run() {
                    NewFileComparisonPanel.this.panel.doGoToFirst();
                    NewFileComparisonPanel.this.panel.repaint();
                }
            };
        }
    }
}

