/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.Filter;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.util.ObjectUtil;
import org.jmeld.util.prefs.ComboBoxPreference;
import org.jmeld.util.prefs.ComboBoxSelectionPreference;
import org.jmeld.util.prefs.DirectoryChooserPreference;
import org.jmeld.util.prefs.FileChooserPreference;
import org.jmeld.util.prefs.TabbedPanePreference;

public class NewPanelDialog {
    private static String RIGHT_FILENAME = "RIGHT_FILENAME";
    private static String LEFT_FILENAME = "LEFT_FILENAME";
    private static String RIGHT_DIRECTORY = "RIGHT_DIRECTORY";
    private static String LEFT_DIRECTORY = "LEFT_DIRECTORY";
    private static String VERSION_CONTROL_DIRECTORY = "VERSION_CONTROL_DIRECTORY";
    private JMeldPanel meldPanel;
    private JTabbedPane tabbedPane;
    private Function function;
    private String leftFileName;
    private String rightFileName;
    private JComboBox leftFileComboBox;
    private JComboBox rightFileComboBox;
    private String leftDirectoryName;
    private String rightDirectoryName;
    private JComboBox leftDirectoryComboBox;
    private JComboBox rightDirectoryComboBox;
    private String versionControlDirectoryName;
    private JComboBox versionControlDirectoryComboBox;
    private JComboBox filterComboBox;
    private JDialog dialog;

    public NewPanelDialog(JMeldPanel meldPanel) {
        this.meldPanel = meldPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void show() {
        JOptionPane pane = new JOptionPane(this.getChooseFilePanel());
        pane.setOptionType(2);
        this.dialog = pane.createDialog(this.meldPanel, "Choose files");
        this.dialog.setResizable(true);
        try {
            this.dialog.show();
            if (!ObjectUtil.equals(pane.getValue(), 0)) return;
            switch (this.tabbedPane.getSelectedIndex()) {
                case 0: {
                    this.setFunction(Function.FILE_COMPARISON);
                    return;
                }
                case 1: {
                    this.setFunction(Function.DIRECTORY_COMPARISON);
                    return;
                }
                case 2: {
                    this.setFunction(Function.VERSION_CONTROL);
                    return;
                }
            }
            return;
        }
        finally {
            this.dialog.dispose();
        }
    }

    private void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public String getLeftFileName() {
        return this.leftFileName;
    }

    public String getRightFileName() {
        return this.rightFileName;
    }

    public String getLeftDirectoryName() {
        return this.leftDirectoryName;
    }

    public String getRightDirectoryName() {
        return this.rightDirectoryName;
    }

    public String getVersionControlDirectoryName() {
        return this.versionControlDirectoryName;
    }

    public Filter getFilter() {
        if (this.filterComboBox.getSelectedItem() instanceof Filter) {
            return (Filter)this.filterComboBox.getSelectedItem();
        }
        return null;
    }

    private JComponent getChooseFilePanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("File Comparison", this.getFileComparisonPanel());
        this.tabbedPane.add("Directory Comparison", this.getDirectoryComparisonPanel());
        new TabbedPanePreference("NewPanelTabbedPane", this.tabbedPane);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.tabbedPane, "Center");
        return panel;
    }

    private JComponent getFileComparisonPanel() {
        String columns = "10px, right:pref, 10px, max(150dlu;pref):grow, 5px, pref, 10px";
        String rows = "10px, fill:pref, 5px, fill:pref, 5px, fill:pref, 10px";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        JLabel label = new JLabel("Left");
        JButton button = new JButton("Browse...");
        this.leftFileComboBox = new JComboBox();
        this.leftFileComboBox.setEditable(false);
        this.leftFileComboBox.addActionListener(this.getFileSelectAction());
        new ComboBoxPreference("LeftFile", this.leftFileComboBox);
        button.setActionCommand(LEFT_FILENAME);
        button.addActionListener(this.getFileBrowseAction());
        panel.add((Component)label, cc.xy(2, 2));
        panel.add((Component)this.leftFileComboBox, cc.xy(4, 2));
        panel.add((Component)button, cc.xy(6, 2));
        label = new JLabel("Right");
        button = new JButton("Browse...");
        button.setActionCommand(RIGHT_FILENAME);
        button.addActionListener(this.getFileBrowseAction());
        this.rightFileComboBox = new JComboBox();
        this.rightFileComboBox.setEditable(false);
        this.rightFileComboBox.addActionListener(this.getFileSelectAction());
        new ComboBoxPreference("RightFile", this.rightFileComboBox);
        panel.add((Component)label, cc.xy(2, 4));
        panel.add((Component)this.rightFileComboBox, cc.xy(4, 4));
        panel.add((Component)button, cc.xy(6, 4));
        return panel;
    }

    public ActionListener getFileBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIManager.put("FileChooser.readOnly", Boolean.TRUE);
                JFileChooser chooser = new JFileChooser();
                UIManager.put("FileChooser.readOnly", Boolean.FALSE);
                chooser.setApproveButtonText("Choose");
                chooser.setDialogTitle("Choose file");
                chooser.setFileSelectionMode(0);
                FileChooserPreference pref = new FileChooserPreference("Browse-" + ae.getActionCommand(), chooser);
                Window ancestor = SwingUtilities.getWindowAncestor((Component)ae.getSource());
                int result = chooser.showOpenDialog(ancestor);
                if (result == 0) {
                    pref.save();
                    try {
                        String fileName = chooser.getSelectedFile().getCanonicalPath();
                        JComboBox comboBox = null;
                        if (ae.getActionCommand().equals(LEFT_FILENAME)) {
                            comboBox = NewPanelDialog.this.leftFileComboBox;
                        } else if (ae.getActionCommand().equals(RIGHT_FILENAME)) {
                            comboBox = NewPanelDialog.this.rightFileComboBox;
                        }
                        if (comboBox != null) {
                            comboBox.insertItemAt(fileName, 0);
                            comboBox.setSelectedIndex(0);
                            NewPanelDialog.this.dialog.pack();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    public ActionListener getFileSelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Object source = ae.getSource();
                if (source == NewPanelDialog.this.leftFileComboBox) {
                    NewPanelDialog.this.leftFileName = (String)NewPanelDialog.this.leftFileComboBox.getSelectedItem();
                } else if (source == NewPanelDialog.this.rightFileComboBox) {
                    NewPanelDialog.this.rightFileName = (String)NewPanelDialog.this.rightFileComboBox.getSelectedItem();
                }
            }
        };
    }

    private JComponent getDirectoryComparisonPanel() {
        String columns = "10px, right:pref, 10px, max(150dlu;pref):grow, 5px, pref, 10px";
        String rows = "10px, fill:pref, 5px, fill:pref, 5px, fill:pref, 5px, fill:pref, 10px";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        JLabel label = new JLabel("Left");
        JButton button = new JButton("Browse...");
        this.leftDirectoryComboBox = new JComboBox();
        this.leftDirectoryComboBox.setEditable(false);
        this.leftDirectoryComboBox.addActionListener(this.getDirectorySelectAction());
        new ComboBoxPreference("LeftDirectory", this.leftDirectoryComboBox);
        button.setActionCommand(LEFT_DIRECTORY);
        button.addActionListener(this.getDirectoryBrowseAction());
        panel.add((Component)label, cc.xy(2, 2));
        panel.add((Component)this.leftDirectoryComboBox, cc.xy(4, 2));
        panel.add((Component)button, cc.xy(6, 2));
        label = new JLabel("Right");
        button = new JButton("Browse...");
        button.setActionCommand(RIGHT_DIRECTORY);
        button.addActionListener(this.getDirectoryBrowseAction());
        this.rightDirectoryComboBox = new JComboBox();
        this.rightDirectoryComboBox.setEditable(false);
        this.rightDirectoryComboBox.addActionListener(this.getDirectorySelectAction());
        new ComboBoxPreference("RightDirectory", this.rightDirectoryComboBox);
        panel.add((Component)label, cc.xy(2, 4));
        panel.add((Component)this.rightDirectoryComboBox, cc.xy(4, 4));
        panel.add((Component)button, cc.xy(6, 4));
        label = new JLabel("Filter");
        this.filterComboBox = new JComboBox<Object>(this.getFilters());
        panel.add((Component)label, cc.xy(2, 6));
        panel.add((Component)this.filterComboBox, cc.xy(4, 6));
        new ComboBoxSelectionPreference("Filter", this.filterComboBox);
        return panel;
    }

    public ActionListener getDirectoryBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIManager.put("FileChooser.readOnly", Boolean.TRUE);
                JFileChooser chooser = new JFileChooser();
                UIManager.put("FileChooser.readOnly", Boolean.FALSE);
                chooser.setApproveButtonText("Choose");
                chooser.setDialogTitle("Choose directory");
                chooser.setFileSelectionMode(1);
                DirectoryChooserPreference pref = new DirectoryChooserPreference("Browse-" + ae.getActionCommand(), chooser);
                Window ancestor = SwingUtilities.getWindowAncestor((Component)ae.getSource());
                int result = chooser.showOpenDialog(ancestor);
                if (result == 0) {
                    pref.save();
                    try {
                        String fileName = chooser.getSelectedFile().getCanonicalPath();
                        JComboBox comboBox = null;
                        if (ae.getActionCommand().equals(LEFT_DIRECTORY)) {
                            comboBox = NewPanelDialog.this.leftDirectoryComboBox;
                        } else if (ae.getActionCommand().equals(RIGHT_DIRECTORY)) {
                            comboBox = NewPanelDialog.this.rightDirectoryComboBox;
                        }
                        if (comboBox != null) {
                            comboBox.insertItemAt(fileName, 0);
                            comboBox.setSelectedIndex(0);
                            NewPanelDialog.this.dialog.pack();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    public ActionListener getDirectorySelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Object source = ae.getSource();
                if (source == NewPanelDialog.this.leftDirectoryComboBox) {
                    NewPanelDialog.this.leftDirectoryName = (String)NewPanelDialog.this.leftDirectoryComboBox.getSelectedItem();
                } else if (source == NewPanelDialog.this.rightDirectoryComboBox) {
                    NewPanelDialog.this.rightDirectoryName = (String)NewPanelDialog.this.rightDirectoryComboBox.getSelectedItem();
                }
            }
        };
    }

    private JComponent getVersionControlPanel() {
        String columns = "10px, right:pref, 10px, max(150dlu;pref):grow, 5px, pref, 10px";
        String rows = "10px, fill:pref, 5px, fill:pref, 5px, fill:pref, 5px, fill:pref, 10px";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        JLabel label = new JLabel("Directory");
        JButton button = new JButton("Browse...");
        this.versionControlDirectoryComboBox = new JComboBox();
        this.versionControlDirectoryComboBox.setEditable(false);
        this.versionControlDirectoryComboBox.addActionListener(this.getVersionControlDirectorySelectAction());
        new ComboBoxPreference("VersionControlDirectory", this.versionControlDirectoryComboBox);
        button.setActionCommand(VERSION_CONTROL_DIRECTORY);
        button.addActionListener(this.getVersionControlDirectoryBrowseAction());
        panel.add((Component)label, cc.xy(2, 2));
        panel.add((Component)this.versionControlDirectoryComboBox, cc.xy(4, 2));
        panel.add((Component)button, cc.xy(6, 2));
        return panel;
    }

    public ActionListener getVersionControlDirectoryBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                UIManager.put("FileChooser.readOnly", Boolean.TRUE);
                JFileChooser chooser = new JFileChooser();
                UIManager.put("FileChooser.readOnly", Boolean.FALSE);
                chooser.setApproveButtonText("Choose");
                chooser.setDialogTitle("Choose directory");
                chooser.setFileSelectionMode(1);
                DirectoryChooserPreference pref = new DirectoryChooserPreference("VersionControlBrowse", chooser);
                Window ancestor = SwingUtilities.getWindowAncestor((Component)ae.getSource());
                int result = chooser.showOpenDialog(ancestor);
                if (result == 0) {
                    pref.save();
                    try {
                        String fileName = chooser.getSelectedFile().getCanonicalPath();
                        JComboBox comboBox = NewPanelDialog.this.versionControlDirectoryComboBox;
                        comboBox.insertItemAt(fileName, 0);
                        comboBox.setSelectedIndex(0);
                        NewPanelDialog.this.dialog.pack();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    public ActionListener getVersionControlDirectorySelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewPanelDialog.this.versionControlDirectoryName = (String)NewPanelDialog.this.versionControlDirectoryComboBox.getSelectedItem();
            }
        };
    }

    private Object[] getFilters() {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add("No filter");
        for (Filter f : JMeldSettings.getInstance().getFilter().getFilters()) {
            filters.add(f);
        }
        return filters.toArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Function {
        FILE_COMPARISON,
        DIRECTORY_COMPARISON,
        VERSION_CONTROL;

    }
}

