/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jmeld.JMeldException;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.util.ObjectUtil;

public class SavePanelDialog {
    private JMeldPanel meldPanel;
    private boolean ok;
    private List<BufferDocumentIF> documents;
    private JCheckBox[] checkBoxes;

    public SavePanelDialog(JMeldPanel meldPanel) {
        this.meldPanel = meldPanel;
        this.documents = new ArrayList<BufferDocumentIF>();
    }

    public void add(BufferDocumentIF document) {
        this.documents.add(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        JOptionPane pane = new JOptionPane(this.getSavePanel(), 2);
        pane.setOptionType(2);
        JDialog dialog = pane.createDialog(this.meldPanel, "Save files");
        dialog.setResizable(true);
        try {
            dialog.show();
            if (ObjectUtil.equals(pane.getValue(), 0)) {
                this.ok = true;
            }
        }
        finally {
            dialog.dispose();
        }
    }

    public boolean isOK() {
        return this.ok;
    }

    public void doSave() {
        if (this.checkBoxes == null) {
            return;
        }
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            BufferDocumentIF document;
            if (!this.checkBoxes[i].isSelected() || (document = this.documents.get(i)) == null) continue;
            try {
                document.write();
                continue;
            }
            catch (JMeldException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.meldPanel, "Can't write file" + document.getName(), "Problem writing file", 0);
            }
        }
    }

    private JComponent getSavePanel() {
        int i;
        String columns = "10px, fill:pref, 10px";
        String rows = "10px, fill:pref, 5px, fill:pref, 10px,";
        for (i = 0; i < this.documents.size(); ++i) {
            rows = rows + " fill:pref, ";
        }
        rows = rows + " 10px";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        JPanel panel = new JPanel(layout);
        JLabel label = new JLabel("Some files have been changed");
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
        label.setHorizontalAlignment(2);
        panel.add((Component)label, cc.xy(2, 2));
        label = new JLabel("Which ones would you like to save?");
        label.setFont(font);
        label.setHorizontalAlignment(2);
        panel.add((Component)label, cc.xy(2, 4));
        this.checkBoxes = new JCheckBox[this.documents.size()];
        for (i = 0; i < this.documents.size(); ++i) {
            JCheckBox checkBox;
            BufferDocumentIF document = this.documents.get(i);
            if (document == null) continue;
            this.checkBoxes[i] = checkBox = new JCheckBox(document.getName());
            if (!document.isChanged()) {
                checkBox.setEnabled(false);
            } else {
                checkBox.setSelected(true);
            }
            panel.add((Component)checkBox, cc.xy(2, 6 + i));
        }
        return panel;
    }
}

