/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbPersister {
    private static JaxbPersister instance = new JaxbPersister();
    private Map<Class, Context> contexts = new HashMap<Class, Context>();

    private JaxbPersister() {
    }

    public static JaxbPersister getInstance() {
        return instance;
    }

    public <T> T load(Class<T> clazz, File file) throws FileNotFoundException, JAXBException {
        return this.load(clazz, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T load(Class<T> clazz, InputStream is) throws JAXBException {
        Context context;
        Context context2 = context = this.getContext(clazz);
        synchronized (context2) {
            Object object = context.unmarshal(is);
            return (T)object;
        }
    }

    public void save(Object object, File file) throws JAXBException, IOException {
        FileOutputStream os = new FileOutputStream(file);
        this.save(object, os);
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Object object, OutputStream os) throws JAXBException, IOException {
        Context context;
        OutputStreamWriter writer = new OutputStreamWriter(os);
        Context context2 = context = this.getContext(object.getClass());
        synchronized (context2) {
            context.marshal(object, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(Class clazz) {
        Context c;
        Map<Class, Context> map = this.contexts;
        synchronized (map) {
            c = this.contexts.get(clazz);
            if (c == null) {
                c = new Context(clazz);
                this.contexts.put(clazz, c);
            }
        }
        return c;
    }

    class Context {
        private JAXBContext jaxbContext;
        private Marshaller marshaller;
        private Unmarshaller unmarshaller;

        Context(Class clazz) {
            try {
                this.jaxbContext = JAXBContext.newInstance(clazz);
                this.marshaller = this.jaxbContext.createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                this.marshaller.setSchema(null);
                this.unmarshaller = this.jaxbContext.createUnmarshaller();
                this.unmarshaller.setSchema(null);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }

        public void marshal(Object object, Writer writer) throws JAXBException {
            this.marshaller.marshal(object, writer);
        }

        public Object unmarshal(InputStream is) throws JAXBException {
            return this.unmarshaller.unmarshal(is);
        }
    }
}

