/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.CustomUIProvider;
import com.inet.jortho.SpellChecker;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;

public class Utils {
    static String getResource(String value) {
        try {
            ResourceBundle resource = ResourceBundle.getBundle("com.inet.jortho.i18n.resource");
            return resource.getString(value);
        }
        catch (Exception e) {
            if (!value.endsWith(".tooltip")) {
                SpellChecker.getMessageHandler().handleException(e);
            }
            return value;
        }
    }

    static JButton getButton(String resource) {
        JButton button;
        CustomUIProvider customProvider = SpellChecker.getCustomUIProvider();
        if (customProvider != null) {
            button = customProvider.getButton(resource);
        } else {
            button = new JButton(Utils.getResource(resource));
            String tooltipKey = String.valueOf(resource) + ".tooltip";
            String tooltip = Utils.getResource(tooltipKey);
            if (tooltip != tooltipKey) {
                button.setToolTipText(tooltip);
            }
        }
        return button;
    }

    static JTextField getTextField() {
        CustomUIProvider customProvider = SpellChecker.getCustomUIProvider();
        JTextField textField = customProvider != null ? customProvider.getTextField() : new JTextField();
        return textField;
    }

    static JLabel getLabel(String text) {
        CustomUIProvider customProvider = SpellChecker.getCustomUIProvider();
        JLabel label = customProvider != null ? customProvider.getLabel(text) : new JLabel(text);
        return label;
    }

    static JList getList() {
        CustomUIProvider customProvider = SpellChecker.getCustomUIProvider();
        if (customProvider != null) {
            return customProvider.getList();
        }
        return new JList();
    }

    static void setDialogIcon(JDialog dlg) {
        try {
            BufferedImage image = ImageIO.read(dlg.getClass().getResourceAsStream("icon.png"));
            Class<Dialog> cls = Dialog.class;
            Method m = cls.getMethod("setIconImage", Image.class);
            m.invoke((Object)dlg, image);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String getCapitalized(String word) {
        if (word.length() > 0 && Character.isLowerCase(word.charAt(0))) {
            return String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1);
        }
        return word;
    }

    static String getInvertedCapitalizion(String word) {
        if (word.length() > 0) {
            if (Character.isLowerCase(word.charAt(0))) {
                return String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1);
            }
            if (Character.isUpperCase(word.charAt(0))) {
                return String.valueOf(word.substring(0, 1).toLowerCase()) + word.substring(1);
            }
        }
        return word;
    }

    static boolean isFirstCapitalized(String word) {
        return word.length() > 0 && Character.isUpperCase(word.charAt(0));
    }

    static boolean isAllCapitalized(String word) {
        int i = 0;
        while (i < word.length()) {
            char ch = word.charAt(i);
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isIncludeNumbers(String word) {
        int i = 0;
        while (i < word.length()) {
            char ch = word.charAt(i);
            if (Character.isDigit(ch)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String replaceUnicodeQuotation(String word) {
        char[] newWord = null;
        int i = 0;
        while (i < word.length()) {
            char ch = word.charAt(i);
            switch (ch) {
                case '`': 
                case '\u00b4': 
                case '\u2018': 
                case '\u2019': 
                case '\u201a': 
                case '\u201b': {
                    if (newWord == null) {
                        newWord = word.toCharArray();
                    }
                    newWord[i] = 39;
                    break;
                }
                case '\u2011': 
                case '\u2012': 
                case '\u2013': 
                case '\u2014': 
                case '\u2015': {
                    if (newWord == null) {
                        newWord = word.toCharArray();
                    }
                    newWord[i] = 45;
                }
            }
            ++i;
        }
        return newWord == null ? word : new String(newWord);
    }
}

