/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BookGenerator_de
extends BookGenerator {
    public BookGenerator_de() {
        this.addWord("Ihnen");
        this.addWord("Ihrer");
        this.addWord("Ihre");
        this.addWord("Ihres");
        this.addWord("Ihrem");
        this.addWord("Ihren");
        this.addWord("Sie");
        this.addWord("Du");
    }

    @Override
    protected boolean isValidWord(String word) {
        if (super.isValidWord(word)) {
            return true;
        }
        return word.endsWith("(Deklination)") || word.endsWith("(Konjugation)") || word.equals("Wiktionary:Wunschliste");
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        wikiText = this.removeHtmlFormating(wikiText);
        if (word.equals("Wiktionary:Wunschliste")) {
            this.addLinkWords(word, wikiText, "Wunschliste");
            return false;
        }
        int idxGerman = wikiText.indexOf("{{Sprache|Deutsch}}");
        if (idxGerman < 0 || word.endsWith("(Deklination)") || word.endsWith("(Konjugation)")) {
            Properties props = BookUtils.parseRule(wikiText, "Deklinationsseite Adjektiv", 0);
            if (props != null) {
                this.addDeklinationAdjektiv(props);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb unregelm\u00e4\u00dfig", 0);
            if (props != null) {
                this.addKonjugationVerbUnregular(props);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach untrennbar", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachUntrennbar(props, false);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach untrennbar reflexiv", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachUntrennbar(props, true);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach trennbar", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachTrennbar(props, false);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach trennbar reflexiv", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachTrennbar(props, true);
                return false;
            }
            props = BookUtils.parseRule(wikiText, "Deutsch Verb schwach doppelt trennbar", 0);
            if (props != null) {
                this.addKonjugationVerbSchwachDoppeltTrennbar(props);
                return false;
            }
            return false;
        }
        do {
            String chapter = this.getChapter(wikiText, idxGerman);
            this.searchFlexion(word, chapter);
            idxGerman = wikiText.indexOf(chapter) + chapter.length();
        } while ((idxGerman = wikiText.indexOf("{{Sprache|Deutsch}}", idxGerman)) > 0);
        return true;
    }

    private final void searchFlexion(String word, String wikiText) {
        int lastIdx;
        int idx = wikiText.indexOf("{{Wortart|Verb|Deutsch}}");
        while (idx > 0) {
            String table = this.getTable(wikiText, "Verb-Tabelle", idx);
            if (table.length() > 0 && this.searchWordAndAdd(word, table, "Gegenwart_ich=", 0)) {
                this.searchWordAndAdd(word, table, "Gegenwart_du=", 0);
                this.searchWordAndAdd(word, table, "Gegenwart_er, sie, es=", 0);
                this.searchWordAndAdd(word, table, "1.Vergangenheit_ich=", 0);
                this.searchWordAndAdd(word, table, "Partizip II=", 0);
                this.searchWordAndAdd(word, table, "Konjunktiv II_ich=", 0);
                this.searchWordAndAdd(word, table, "Befehl_du=", 0);
                this.searchWordAndAdd(word, table, "Befehl_ihr=", 0);
            }
            lastIdx = idx + 1;
            idx = wikiText.indexOf("{{Wortart|Verb|Deutsch}}", lastIdx);
        }
        idx = wikiText.indexOf("{{Wortart|Substantiv}}");
        if (idx < 0) {
            idx = wikiText.indexOf("{{Wortart|Substantiv|Deutsch}}");
        }
        while (idx > 0) {
            String chapter = this.getChapter(wikiText, idx);
            this.addDeklinationSubstTable(chapter, 0, word);
            lastIdx = idx + 1;
            idx = wikiText.indexOf("{{Wortart|Substantiv}}", lastIdx);
            if (idx >= 0) continue;
            idx = wikiText.indexOf("{{Wortart|Substantiv|Deutsch}}", lastIdx);
        }
        idx = wikiText.indexOf("{{Wortart|Adjektiv|Deutsch}}");
        while (idx > 0) {
            Properties props = BookUtils.parseRule(wikiText, "Deutsch Adjektiv \u00dcbersicht", idx);
            if (props != null) {
                String grundform = props.getProperty("Positiv");
                this.addFormatedWordPhrase(word, "Positiv", grundform);
                this.addFormatedWordPhrase(word, "Komparativ", props.getProperty("Komparativ"));
                this.addFormatedWordPhrase(word, "Superlativ", props.getProperty("Superlativ"));
                if (grundform == null || !super.isValidWord(grundform)) {
                    grundform = word;
                }
                if (!grundform.endsWith("e")) {
                    this.addDeklinationAdjektiv(grundform);
                }
            }
            lastIdx = idx + 1;
            idx = wikiText.indexOf("{{Wortart|Adjektiv|Deutsch}}", lastIdx);
        }
        if (wikiText.indexOf("{{Wortart|Partizip I|Deutsch}}") >= 0) {
            this.addDeklinationAdjektiv(word);
        }
        if (wikiText.indexOf("{{Wortart|Partizip II|Deutsch}}") >= 0) {
            this.addDeklinationAdjektiv(word);
        }
        if (wikiText.indexOf("{{Wortart|Indefinitpronomen|Deutsch}}") >= 0) {
            this.addIndefinitpronomen(word, wikiText);
        }
        this.searchExtendsWords(word, wikiText, "{{Synonyme}}");
        this.searchExtendsWords(word, wikiText, "{{Unterbegriffe}}");
        this.searchExtendsWords(word, wikiText, "{{Abgeleitete Begriffe}}");
    }

    private String getChapter(String wikiText, int headerIdx) {
        int startIdx = wikiText.lastIndexOf(10, headerIdx) + 1;
        int endIdx = wikiText.indexOf(10, headerIdx);
        if (endIdx == -1) {
            return wikiText.substring(startIdx);
        }
        String header = wikiText.substring(startIdx, endIdx).trim();
        int prefixSize = 0;
        while (header.length() > prefixSize && header.charAt(prefixSize) == '=') {
            ++prefixSize;
        }
        if (prefixSize == 0) {
            return wikiText.substring(startIdx);
        }
        String marker = header.substring(0, prefixSize);
        if (!header.endsWith(marker)) {
            return wikiText.substring(startIdx);
        }
        Pattern pattern = Pattern.compile("^" + marker + "[^=].*[^=]" + marker + "\\s*$", 8);
        Matcher matcher = pattern.matcher(wikiText);
        if (matcher.find(endIdx)) {
            String chapter = wikiText.substring(startIdx, matcher.start()).trim();
            if (header.equals(chapter)) {
                return wikiText.substring(startIdx);
            }
            return chapter;
        }
        return wikiText.substring(startIdx);
    }

    private String getTable(String wikiText, String tableName, int fromIndex) {
        int start = wikiText.indexOf("{{" + tableName, fromIndex);
        if (start > 0) {
            int length = wikiText.length();
            int braces = 0;
            int end = start;
            while (end < length) {
                switch (wikiText.charAt(end)) {
                    case '{': {
                        ++braces;
                        break;
                    }
                    case '}': {
                        if (--braces != 0) break;
                        return wikiText.substring(start, end + 1);
                    }
                }
                ++end;
            }
        }
        return "";
    }

    private final boolean searchWordAndAdd(String baseWord, String wikiText, String marker, int fromIndex) {
        int idx1 = wikiText.indexOf(marker, fromIndex);
        if (idx1 > 0) {
            int idx2 = this.indexOf(wikiText, new char[]{'|', '<', '}', '{'}, idx1 += marker.length());
            if (idx2 > 0) {
                String word = wikiText.substring(idx1, idx2).trim();
                this.addFormatedWordPhrase(baseWord, marker, word);
                return true;
            }
            System.out.println("End not found for marker '" + marker + "' for base word '" + baseWord + "'");
        } else {
            System.out.println("Marker '" + marker + "' was not found for base word '" + baseWord + "'");
        }
        return false;
    }

    private boolean searchExtendsWords(String baseWord, String wikiText, String marker) {
        int idx1 = wikiText.indexOf(marker);
        if (idx1 >= 0) {
            int idx2 = this.indexOf(wikiText, new char[]{'{', '='}, idx1 += marker.length());
            if (idx2 < 0) {
                idx2 = wikiText.length();
            }
            String extendsWords = wikiText.substring(idx1, idx2);
            this.addLinkWords(baseWord, extendsWords, marker);
            return true;
        }
        return false;
    }

    private void addLinkWords(String baseWord, String wikiText, String marker) {
        int idx3 = wikiText.indexOf("[[");
        while (idx3 > 0) {
            int idx4 = wikiText.indexOf("]]", idx3);
            if (idx4 > 0) {
                if (idx3 + 2 < idx4) {
                    String word = wikiText.substring(idx3 + 2, idx4);
                    if (word.startsWith("WikiSaurus:")) {
                        word = word.substring(11).trim();
                    }
                    if (word.startsWith("Thesaurus:")) {
                        word = word.substring(10).trim();
                    }
                    if (word.indexOf(124) > 0) {
                        word = word.substring(0, word.indexOf(124));
                    }
                    if (!this.addWordPhrase(word)) {
                        System.out.println("Invalid Extend Word '" + word + "' for marker '" + marker + "' for base word '" + baseWord + "'");
                    }
                }
                idx3 = wikiText.indexOf("[[", idx4);
                continue;
            }
            idx3 = -1;
        }
    }

    private final void addFormatedWordPhrase(String baseWord, String key, String phrase) {
        if (phrase == null) {
            return;
        }
        if (phrase.endsWith("!") || phrase.endsWith("\u2019")) {
            phrase = phrase.substring(0, phrase.length() - 1);
        }
        if (phrase.length() <= 1) {
            return;
        }
        if (phrase.equals("{{fehlend}}") || phrase.equals("---") || phrase.equals("--") || phrase.equals("{{center")) {
            return;
        }
        int idx3 = phrase.indexOf("(");
        int idx4 = phrase.indexOf(")", idx3);
        if (idx3 >= 0 && idx4 > 0) {
            String word3;
            String word1 = phrase.substring(0, idx3);
            String word2 = phrase.substring(idx4 + 1);
            String string = word3 = word1.length() + word2.length() > 0 ? String.valueOf(word1) + word2 : phrase.substring(idx3 + 1, idx4);
            if (this.addWordPhrase(word3)) {
                this.addWordPhrase(String.valueOf(word1) + phrase.substring(idx3 + 1, idx4) + word2);
                return;
            }
            System.out.println("Invalid Word '" + phrase + "' for marker '" + key + "' for base word '" + baseWord + "'");
        } else {
            if (this.addWordPhrase(phrase)) {
                return;
            }
            System.out.println("Invalid Word '" + phrase + "' for marker '" + key + "' for base word '" + baseWord + "'");
        }
    }

    private final boolean addWordPhrase(String phrase) {
        boolean isValid = true;
        int index = phrase.indexOf("[e]");
        if (index > 0 && Character.isLetter(phrase.charAt(index - 1))) {
            int i = 0;
            while (i < 2) {
                this.addWordPhrase(String.valueOf(phrase.substring(0, index)) + (i == 0 ? "e" : "") + phrase.substring(index + 3));
                ++i;
            }
        } else {
            String[] words = phrase.split("(\\s|/|,|!)+");
            int i = 0;
            while (i < words.length) {
                String word = words[i];
                if (word.length() > 0) {
                    if (super.isValidWord(word)) {
                        this.addWord(word);
                    } else {
                        isValid = false;
                    }
                }
                ++i;
            }
        }
        return isValid;
    }

    private void addDeklinationAdjektiv(Properties props) {
        this.addDeklinationAdjektiv(props.getProperty("Positiv-Stamm"));
        this.addDeklinationAdjektiv(props.getProperty("Komparativ-Stamm"));
        this.addDeklinationAdjektiv(props.getProperty("Superlativ-Stamm"));
    }

    private void addDeklinationAdjektiv(String wordStamm) {
        if (wordStamm != null && super.isValidWord(wordStamm)) {
            this.addWord(String.valueOf(wordStamm) + "e");
            this.addWord(String.valueOf(wordStamm) + "er");
            this.addWord(String.valueOf(wordStamm) + "es");
            this.addWord(String.valueOf(wordStamm) + "en");
            this.addWord(String.valueOf(wordStamm) + "em");
        }
    }

    private void addIndefinitpronomen(String word, String wikiText) {
        Properties props = BookUtils.parseRule(wikiText, "Pronomina-Tabelle", 0);
        if (props != null) {
            Set<Map.Entry<Object, Object>> entries = props.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                this.addFormatedWordPhrase(word, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private boolean addDeklinationSubstTable(String wikiText, int fromIndex, String baseWord) {
        Properties props = BookUtils.parseRule(wikiText, "Deutsch Substantiv \u00dcbersicht", fromIndex);
        if (props != null) {
            if (props.remove("Bild") != null || props.remove("Bild 1") != null) {
                props.remove("1");
                props.remove("2");
                props.remove("3");
            }
            if (props.remove("Bild 2") != null) {
                props.remove("4");
                props.remove("5");
                props.remove("6");
            }
            if (props.remove("Bild 3") != null) {
                props.remove("7");
                props.remove("8");
                props.remove("9");
            }
            if (props.remove("Bild 4") != null) {
                props.remove("10");
                props.remove("11");
                props.remove("12");
            }
            if (props.remove("Bild 5") != null) {
                props.remove("13");
                props.remove("14");
                props.remove("15");
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String word = (String)entry.getValue();
                this.addFormatedWordPhrase(baseWord, (String)entry.getKey(), word);
            }
            return true;
        }
        return false;
    }

    private String removeHtmlFormating(String word) {
        int idx1 = word.indexOf(60);
        while (idx1 >= 0) {
            int idx2 = word.indexOf(62, idx1);
            if (idx2 > 0) {
                String html = word.substring(idx1 + 1, idx2).toLowerCase().trim();
                html = html.equals("br") || html.equals("p") || html.startsWith("br ") || html.startsWith("p ") ? " " : "";
                word = String.valueOf(word.substring(0, idx1)) + html + word.substring(idx2 + 1);
                idx1 = word.indexOf(60);
                continue;
            }
            idx1 = -1;
        }
        String[] stringArray = new String[]{"&nbsp;", "&#32;"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String blank = stringArray[n2];
            idx1 = word.indexOf(blank);
            while (idx1 >= 0) {
                word = String.valueOf(word.substring(0, idx1)) + " " + word.substring(idx1 + blank.length());
                idx1 = word.indexOf(blank);
            }
            ++n2;
        }
        return word;
    }

    private void addKonjugationVerbUnregular(Properties props) {
        String vorsilbe = props.getProperty("1", "");
        String stamm = props.getProperty("2");
        this.addWord(String.valueOf(vorsilbe) + stamm + "end");
        if ("ja".equals(props.getProperty("gerund"))) {
            String gerund = vorsilbe.length() > 0 ? String.valueOf(vorsilbe) + "zu" + stamm : stamm;
            this.addWord(String.valueOf(gerund) + "nder");
            this.addWord(String.valueOf(gerund) + "nde");
            this.addWord(String.valueOf(gerund) + "ndes");
            this.addWord(String.valueOf(gerund) + "nden");
            this.addWord(String.valueOf(gerund) + "ndem");
        }
        if (stamm != null && super.isValidWord(stamm)) {
            this.addWord(String.valueOf(stamm) + "e");
            this.addWord(String.valueOf(stamm) + "st");
            this.addWord(String.valueOf(stamm) + "t");
            this.addWord(String.valueOf(stamm) + "en");
            this.addWord(String.valueOf(stamm) + "est");
            this.addWord(String.valueOf(stamm) + "et");
            if (vorsilbe.length() > 0) {
                this.addWord(String.valueOf(vorsilbe) + stamm);
                this.addWord(String.valueOf(vorsilbe) + stamm + "e");
                this.addWord(String.valueOf(vorsilbe) + stamm + "st");
                this.addWord(String.valueOf(vorsilbe) + stamm + "t");
                this.addWord(String.valueOf(vorsilbe) + stamm + "en");
                this.addWord(String.valueOf(vorsilbe) + stamm + "est");
                this.addWord(String.valueOf(vorsilbe) + stamm + "et");
            }
        }
        if ((stamm = props.getProperty("3")) != null && super.isValidWord(stamm)) {
            this.addWord(stamm);
            this.addWord(String.valueOf(stamm) + "st");
            this.addWord(String.valueOf(stamm) + "en");
            this.addWord(String.valueOf(stamm) + "t");
            if (vorsilbe.length() > 0) {
                this.addWord(String.valueOf(vorsilbe) + stamm);
                this.addWord(String.valueOf(vorsilbe) + stamm + "st");
                this.addWord(String.valueOf(vorsilbe) + stamm + "en");
                this.addWord(String.valueOf(vorsilbe) + stamm + "t");
            }
        }
        if ((stamm = props.getProperty("4")) != null && super.isValidWord(stamm)) {
            this.addWord(String.valueOf(stamm) + "e");
            this.addWord(String.valueOf(stamm) + "est");
            this.addWord(String.valueOf(stamm) + "en");
            this.addWord(String.valueOf(stamm) + "et");
            if (vorsilbe.length() > 0) {
                this.addWord(String.valueOf(vorsilbe) + stamm);
                this.addWord(String.valueOf(vorsilbe) + stamm + "est");
                this.addWord(String.valueOf(vorsilbe) + stamm + "en");
                this.addWord(String.valueOf(vorsilbe) + stamm + "et");
            }
        }
        if ((stamm = props.getProperty("5")) != null && super.isValidWord(stamm)) {
            this.addWord(String.valueOf(vorsilbe) + stamm);
            this.addDeklinationAdjektiv(String.valueOf(vorsilbe) + stamm);
        }
    }

    private void addKonjugationVerbSchwachUntrennbar(Properties props, boolean reflexiv) {
        String stamm4;
        String partizip2 = props.getProperty("6");
        if (partizip2 != null && super.isValidWord(partizip2)) {
            this.addWord(partizip2);
            this.addDeklinationAdjektiv(partizip2);
        }
        if (super.isValidWord(stamm4 = String.valueOf(props.getProperty("1")) + props.getProperty("2") + props.getProperty("3") + props.getProperty("4"))) {
            this.addWord(String.valueOf(stamm4) + "nd");
            if (!reflexiv) {
                this.addWord(String.valueOf(stamm4) + "nder");
                this.addWord(String.valueOf(stamm4) + "nde");
                this.addWord(String.valueOf(stamm4) + "ndes");
                this.addWord(String.valueOf(stamm4) + "nden");
                this.addWord(String.valueOf(stamm4) + "ndem");
            }
            String stamm3 = String.valueOf(props.getProperty("1")) + props.getProperty("2") + props.getProperty("3");
            this.addWord(stamm4);
            this.addWord(String.valueOf(stamm3) + "st");
            this.addWord(String.valueOf(stamm3) + "t");
            this.addWord(String.valueOf(stamm3) + "est");
            this.addWord(String.valueOf(stamm3) + "e");
            this.addWord(String.valueOf(stamm3) + "et");
            this.addWord(String.valueOf(stamm3) + "te");
            this.addWord(String.valueOf(stamm3) + "test");
            this.addWord(String.valueOf(stamm3) + "ten");
            this.addWord(String.valueOf(stamm3) + "tet");
        }
    }

    private void addKonjugationVerbSchwachTrennbar(Properties props, boolean reflexiv) {
        String partizip2 = props.getProperty("7");
        if (partizip2 != null && super.isValidWord(partizip2)) {
            this.addWord(partizip2);
            this.addDeklinationAdjektiv(partizip2);
        }
        String vorsilbe = props.getProperty("1");
        String stamm4 = String.valueOf(props.getProperty("2")) + props.getProperty("3") + props.getProperty("4");
        String stamm5 = String.valueOf(stamm4) + props.getProperty("5");
        String all4 = String.valueOf(vorsilbe) + stamm4;
        String all5 = String.valueOf(vorsilbe) + stamm5;
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm5 + "n");
        this.addWord(String.valueOf(all5) + "nd");
        if (!reflexiv) {
            this.addWord(String.valueOf(vorsilbe) + "zu" + stamm5 + "nder");
            this.addWord(String.valueOf(vorsilbe) + "zu" + stamm5 + "nde");
            this.addWord(String.valueOf(vorsilbe) + "zu" + stamm5 + "ndes");
            this.addWord(String.valueOf(vorsilbe) + "zu" + stamm5 + "nden");
            this.addWord(String.valueOf(vorsilbe) + "zu" + stamm5 + "ndem");
        }
        this.addWord(stamm5);
        this.addWord(String.valueOf(stamm4) + "st");
        this.addWord(String.valueOf(stamm4) + "t");
        this.addWord(String.valueOf(stamm4) + "est");
        this.addWord(String.valueOf(stamm4) + "e");
        this.addWord(String.valueOf(stamm5) + "n");
        this.addWord(String.valueOf(stamm4) + "et");
        this.addWord(all5);
        this.addWord(String.valueOf(all4) + "st");
        this.addWord(String.valueOf(all4) + "t");
        this.addWord(String.valueOf(all4) + "est");
        this.addWord(String.valueOf(all4) + "e");
        this.addWord(String.valueOf(all5) + "n");
        this.addWord(String.valueOf(all4) + "et");
        this.addWord(String.valueOf(stamm4) + "te");
        this.addWord(String.valueOf(stamm4) + "test");
        this.addWord(String.valueOf(stamm4) + "ten");
        this.addWord(String.valueOf(stamm4) + "tet");
        this.addWord(String.valueOf(all4) + "te");
        this.addWord(String.valueOf(all4) + "test");
        this.addWord(String.valueOf(all4) + "ten");
        this.addWord(String.valueOf(all4) + "tet");
    }

    private void addKonjugationVerbSchwachDoppeltTrennbar(Properties props) {
        String partizip2 = props.getProperty("8");
        if (partizip2 != null && super.isValidWord(partizip2)) {
            this.addWord(partizip2);
            this.addDeklinationAdjektiv(partizip2);
        }
        String vorsilbe = String.valueOf(props.getProperty("1")) + props.getProperty("2");
        String stamm5 = String.valueOf(props.getProperty("3")) + props.getProperty("4") + props.getProperty("5");
        String stamm6 = String.valueOf(stamm5) + props.getProperty("6");
        String all5 = String.valueOf(vorsilbe) + stamm5;
        String all6 = String.valueOf(vorsilbe) + stamm6;
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm6 + "n");
        this.addWord(String.valueOf(all6) + "nd");
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm6 + "nder");
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm6 + "nde");
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm6 + "ndes");
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm6 + "nden");
        this.addWord(String.valueOf(vorsilbe) + "zu" + stamm6 + "ndem");
        this.addWord(stamm6);
        this.addWord(String.valueOf(stamm5) + "st");
        this.addWord(String.valueOf(stamm5) + "t");
        this.addWord(String.valueOf(stamm5) + "est");
        this.addWord(String.valueOf(stamm5) + "e");
        this.addWord(String.valueOf(stamm6) + "n");
        this.addWord(String.valueOf(stamm5) + "et");
        this.addWord(all6);
        this.addWord(String.valueOf(all5) + "st");
        this.addWord(String.valueOf(all5) + "t");
        this.addWord(String.valueOf(all5) + "est");
        this.addWord(String.valueOf(all5) + "e");
        this.addWord(String.valueOf(all6) + "n");
        this.addWord(String.valueOf(all5) + "et");
        this.addWord(String.valueOf(stamm5) + "te");
        this.addWord(String.valueOf(stamm5) + "test");
        this.addWord(String.valueOf(stamm5) + "ten");
        this.addWord(String.valueOf(stamm5) + "tet");
        this.addWord(String.valueOf(all5) + "te");
        this.addWord(String.valueOf(all5) + "test");
        this.addWord(String.valueOf(all5) + "ten");
        this.addWord(String.valueOf(all5) + "tet");
    }
}

