/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookUtils;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BookGenerator_en
extends BookGenerator {
    private final Pattern english = Pattern.compile("^==\\s*English\\s*==$", 8);
    private final Pattern languages = Pattern.compile("^==[^=]*==$", 8);

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        int idx2;
        int idx;
        String correctWord;
        Properties props;
        Matcher engMatch = this.english.matcher(wikiText);
        if (!engMatch.find() || wikiText.indexOf("{{rare}}") > 0) {
            return false;
        }
        Matcher matcher = this.languages.matcher(wikiText);
        if (matcher.find(engMatch.end())) {
            wikiText = wikiText.substring(engMatch.end(), matcher.start());
        }
        if ((props = BookUtils.parseRule(wikiText, "misspelling of", 0)) != null && (correctWord = props.getProperty("1")) != null && BookUtils.calcDiff(word, correctWord) <= 3 && wikiText.length() < 250) {
            return false;
        }
        if (wikiText.indexOf("{{en-noun}}") > 0 || wikiText.indexOf("{{en-proper noun}}") > 0) {
            String pluralGenetiv;
            String genetiv = String.valueOf(word) + "'s";
            if (this.isValidWord(genetiv)) {
                this.addWord(genetiv);
            }
            if (this.isValidWord(pluralGenetiv = String.valueOf(word) + "s'")) {
                this.addWord(pluralGenetiv);
            }
        }
        if ((idx = wikiText.indexOf("{{en-noun|pl=")) > 0 && (idx2 = wikiText.indexOf("}}", idx += "{{en-noun|pl=".length())) > 0) {
            String plural = wikiText.substring(idx, idx2);
            if (this.isValidWord(plural = this.trim(plural))) {
                this.addWord(plural);
                plural = String.valueOf(plural) + "'s";
                if (this.isValidWord(plural)) {
                    this.addWord(plural);
                }
            }
        }
        return true;
    }

    private String trim(String word) {
        if ((word = word.trim()).length() >= 6 && word.startsWith("'''") && word.endsWith("'''")) {
            word = word.substring(3, word.length() - 3);
        }
        if ((word = word.trim()).length() >= 4 && word.startsWith("[[") && word.endsWith("]]")) {
            word = word.substring(2, word.length() - 2);
        }
        word = word.trim();
        return word;
    }
}

