/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookUtils;
import java.util.Properties;

public class BookGenerator_nl
extends BookGenerator {
    @Override
    protected boolean isValidWord(String word) {
        if (super.isValidWord(word)) {
            return true;
        }
        return word.endsWith("/vervoeging");
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        boolean isNlWord = wikiText.indexOf("{{=nld=}}") >= 0 && super.isValidWord(word);
        this.addTemplate(word, wikiText, "-nlnoun-", 4);
        this.addTemplate(word, wikiText, "-nlstam-", 7);
        this.addTemplate(word, wikiText, "-nlverb-", 18);
        this.addTemplate(word, wikiText, "-nlverb-onp-", 7);
        this.addTemplate(word, wikiText, "-nlverb-reflex-", 11);
        if (isNlWord) {
            this.addTemplate(word, wikiText, "adjcomp", 6);
            this.addTemplate(word, wikiText, "adjcompp", 9);
        }
        return isNlWord;
    }

    private void addTemplate(String word, String wikiText, String template, int count) {
        Properties props = BookUtils.parseRule(wikiText, template, 0);
        if (props != null) {
            this.addDeclination(word, props, count);
        }
    }

    private void addDeclination(String root, Properties props, int count) {
        int i = 1;
        while (i <= count) {
            String[] words;
            String declination = props.getProperty(String.valueOf(i));
            if (declination == null) {
                return;
            }
            declination = declination.replace("{{pn}}", root);
            declination = declination.replace("<br>", " ");
            declination = declination.replaceAll("<br\\s*?/>", " ");
            declination = declination.replace("<small>", "");
            declination = declination.replace("</small>", "");
            declination = declination.replace(",", " ");
            declination = declination.replace("/", " ");
            declination = this.removeQuotes(declination);
            String[] stringArray = words = declination.split("\\s+");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (super.isValidWord(word = this.removeQuotes(word))) {
                    this.addWord(word);
                }
                ++n2;
            }
            ++i;
        }
    }

    private String removeQuotes(String word) {
        if (word.length() <= 2) {
            return word;
        }
        word = word.replaceAll("\\[\\[(.*?)\\]\\]", "$1");
        char ch1 = word.charAt(0);
        char ch2 = word.charAt(word.length() - 1);
        if (ch1 == '\'' && ch2 == '\'' || ch1 == '(' && ch2 == ')') {
            return this.removeQuotes(word.substring(1, word.length() - 1));
        }
        return word;
    }
}

