/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookGenerator_pl_Engish;
import java.io.File;

public class BookGenerator_pl
extends BookGenerator {
    @Override
    void start(File file) throws Exception {
        String path = file.getPath().replace("plwiktionary", "enwiktionary");
        File fileEnglisch = new File(path);
        BookGenerator_pl_Engish english = new BookGenerator_pl_Engish(this.getBook());
        english.start(fileEnglisch);
        super.start(file);
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        if (wikiText.indexOf("{{j\u0119zyk polski}}") < 0 && wikiText.indexOf("{{J\u0119zyk polski}}") < 0) {
            return false;
        }
        int idx = wikiText.indexOf("{{odmiana}}");
        if (idx > 0) {
            this.odmiana(idx + "{{odmiana}}".length(), wikiText);
        }
        return true;
    }

    private void odmiana(int idx, String wikiText) {
        String wordRoot = null;
        boolean newWordRoot1 = false;
        boolean newWordRoot2 = false;
        StringBuilder builder = new StringBuilder();
        boolean wasNewline = false;
        int bracket = 0;
        while (idx < wikiText.length() && !wasNewline) {
            char ch;
            if ((ch = wikiText.charAt(idx++)) == '\n') {
                wasNewline = true;
            }
            if (newWordRoot1) {
                newWordRoot2 = true;
            }
            if (Character.isWhitespace(ch) && bracket == 0) {
                if (builder.length() == 0) continue;
                String word = builder.toString();
                builder.setLength(0);
                if (word.equals("lp") || word.equals("lm") || word.equals("{{lp}}") || word.equals("{{lm}}") || word.equals("''lp''") || word.equals("''lm''")) {
                    newWordRoot1 = true;
                    continue;
                }
                if (word.charAt(word.length() - 1) == ',' && (word = word.substring(0, word.length() - 1)).length() == 0) continue;
                if (word.charAt(word.length() - 1) == ';') {
                    word = word.substring(0, word.length() - 1);
                    newWordRoot1 = true;
                    if (word.length() == 0) continue;
                }
                if (word.charAt(word.length() - 1) == '!' && (word = word.substring(0, word.length() - 1)).length() == 0 || word.equals("{{m}}") || word.equals("{{f}}") || word.equals("{{n}}") || word.equals("{{mosob}}") || word.equals("{{nmosob}}") || word.equals("{{nieodm}}") || this.isCaseLabel(word)) continue;
                if (wordRoot == null || newWordRoot2) {
                    String possibleRoot;
                    newWordRoot2 = false;
                    newWordRoot1 = false;
                    int pipeIdx = word.indexOf(124);
                    String string = possibleRoot = pipeIdx >= 0 ? word.substring(0, pipeIdx) : word;
                    if (this.isValidWord(possibleRoot)) {
                        wordRoot = possibleRoot;
                        if (pipeIdx >= 0) {
                            word = String.valueOf(wordRoot) + word.substring(pipeIdx + 1);
                        }
                        if (this.isValidWord(word)) {
                            this.addWord(word);
                            continue;
                        }
                        System.err.println(word);
                        System.err.print("");
                        continue;
                    }
                    if (wordRoot == null) {
                        System.err.println("Wordroot: " + word);
                        continue;
                    }
                }
                word = word.replace("~|", wordRoot);
                word = word.replace("~", wordRoot);
                if (this.isValidWord(word = word.replace("-", wordRoot))) {
                    this.addWord(word);
                    continue;
                }
                if (this.isAlternateWords(word)) continue;
                System.err.println(word);
                System.err.print("");
                continue;
            }
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    ++bracket;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    --bracket;
                }
            }
            builder.append(ch);
        }
    }

    private boolean isAlternateWords(String word) {
        String[] words = word.split("/");
        if (words.length > 1) {
            String w;
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                w = stringArray[n2];
                if (!this.isValidWord(w)) {
                    return false;
                }
                ++n2;
            }
            stringArray = words;
            n = words.length;
            n2 = 0;
            while (n2 < n) {
                w = stringArray[n2];
                this.addWord(w);
                ++n2;
            }
            return true;
        }
        return false;
    }

    private boolean isCaseLabel(String word) {
        return word.startsWith("(") && word.length() > 1 && Character.isDigit(word.charAt(1));
    }
}

