/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookGenerator_ru_templates;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class BookGenerator_ru
extends BookGenerator {
    private Hashtable<String, Template> templates = new Hashtable();

    @Override
    void start(File file) throws Exception {
        BookGenerator_ru_templates templateGenerator = new BookGenerator_ru_templates(this);
        templateGenerator.start(file);
        this.templates = templateGenerator.getTemplates();
        System.out.println("\nTemplate Count: " + this.templates.size());
        super.start(file);
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        if (wikiText.indexOf("{{-ru-}}") < 0 && wikiText.indexOf("{{-ru-|") < 0) {
            return false;
        }
        this.findRuleAndAddWords(word, wikiText);
        return true;
    }

    private void findRuleAndAddWords(String word, String wikiText) {
        int idxStart = wikiText.indexOf("{{");
        int idxEnd = wikiText.indexOf("}}", idxStart);
        while (idxStart >= 0 && idxEnd >= 0) {
            Template template;
            Properties props = this.parseRule(wikiText, idxStart + 2, idxEnd);
            String ruleName = props.getProperty("0");
            if (ruleName != null && (template = this.templates.get(ruleName)) != null) {
                template.addWords(word, props);
            }
            idxStart = wikiText.indexOf("{{", idxEnd);
            idxEnd = wikiText.indexOf("}}", idxStart);
        }
    }

    private Properties parseRule(String wikiText, int idxStart, int idxEnd) {
        Properties props = new Properties();
        String[] tokens = wikiText.substring(idxStart, idxEnd).split("\\|");
        int i = 0;
        while (i < tokens.length) {
            String value = tokens[i].trim();
            int idx = value.indexOf(61);
            if (idx > 0) {
                String name = value.substring(0, idx);
                value = value.substring(idx + 1);
                props.setProperty(name, this.normalizeString(value));
            } else {
                props.setProperty(String.valueOf(i), value);
            }
            ++i;
        }
        return props;
    }

    private String normalizeString(String str) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '-': 
                case '\u0301': {
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public class Template {
        private Hashtable<String, String[]> rules = new Hashtable();
        private String templateName;

        Template(String templateName) {
            this.templateName = templateName;
        }

        public void addWords(String word, Properties props) {
            for (Map.Entry<String, String[]> rule : this.rules.entrySet()) {
                String[] endings;
                String root = props.getProperty(rule.getKey());
                if (root == null) continue;
                String[] stringArray = endings = rule.getValue();
                int n = endings.length;
                int n2 = 0;
                while (n2 < n) {
                    String ending = stringArray[n2];
                    BookGenerator_ru.this.addWord(String.valueOf(root) + ending);
                    ++n2;
                }
            }
        }

        int getRuleCount() {
            return this.rules.size();
        }

        String getName() {
            return this.templateName.substring(7);
        }

        void addEnding(String rule, String ending) {
            String[] endings = this.rules.get(rule);
            if (endings == null) {
                endings = new String[1];
            } else {
                String[] stringArray = endings;
                int n = endings.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    if (e.equals(ending)) {
                        return;
                    }
                    ++n2;
                }
                String[] temp = new String[endings.length + 1];
                System.arraycopy(endings, 0, temp, 0, endings.length);
                endings = temp;
            }
            endings[endings.length - 1] = ending;
            this.rules.put(rule, endings);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("//").append(this.templateName).append('\n');
            builder.append("template = new Template();\n");
            for (Map.Entry<String, String[]> rule : this.rules.entrySet()) {
                String[] endings;
                builder.append("template.addRule( \"").append(rule.getKey()).append('\"');
                String[] stringArray = endings = rule.getValue();
                int n = endings.length;
                int n2 = 0;
                while (n2 < n) {
                    String ending = stringArray[n2];
                    builder.append(", \"").append(ending).append("\"");
                    ++n2;
                }
                builder.append(" );\n");
            }
            builder.append("templates.put( \"").append(this.getName()).append("\", template );\n");
            builder.append("\n");
            return builder.toString();
        }
    }
}

