/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jorthodictionaries;

import com.inet.jorthodictionaries.BookGenerator;
import com.inet.jorthodictionaries.BookGenerator_ru;
import java.util.Hashtable;

public class BookGenerator_ru_templates
extends BookGenerator {
    private Hashtable<String, BookGenerator_ru.Template> templates = new Hashtable();
    private final BookGenerator_ru generator;

    BookGenerator_ru_templates(BookGenerator_ru generator) {
        this.generator = generator;
    }

    Hashtable<String, BookGenerator_ru.Template> getTemplates() {
        return this.templates;
    }

    @Override
    protected boolean isValidWord(String word) {
        return word.startsWith("\u0428\u0430\u0431\u043b\u043e\u043d:");
    }

    @Override
    boolean isValidLanguage(String word, String wikiText) {
        BookGenerator_ru.Template template = this.findRules(word, wikiText);
        if (template.getRuleCount() > 0) {
            this.templates.put(template.getName(), template);
            System.out.print(".");
        }
        return false;
    }

    private BookGenerator_ru.Template findRules(String word, String wikiText) {
        int idxStart = wikiText.indexOf("{{{");
        int idxEnd = wikiText.indexOf("}}}", idxStart);
        BookGenerator_ru bookGenerator_ru = this.generator;
        bookGenerator_ru.getClass();
        BookGenerator_ru.Template template = new BookGenerator_ru.Template(bookGenerator_ru, word);
        while (idxStart >= 0 && idxEnd >= 0) {
            String ending;
            String rule = wikiText.substring(idxStart + 3, idxEnd);
            boolean validRule = rule.length() > 0;
            int i = 0;
            while (i < rule.length()) {
                char c = rule.charAt(i);
                if (c != ' ' && !Character.isLetterOrDigit(c)) {
                    validRule = false;
                    break;
                }
                ++i;
            }
            if (validRule && (ending = this.findEnding(wikiText, idxEnd + 3)).length() > 0) {
                template.addEnding(rule, ending);
            }
            idxStart = wikiText.indexOf("{{{", idxEnd);
            idxEnd = wikiText.indexOf("}}}", idxStart);
        }
        return template;
    }

    private String findEnding(String wikiText, int idx) {
        StringBuilder ending = new StringBuilder();
        int i = idx;
        while (i < wikiText.length()) {
            char c = wikiText.charAt(i);
            switch (c) {
                case '\u0301': {
                    break;
                }
                default: {
                    if (!Character.isLetter(c)) {
                        return ending.toString();
                    }
                    ending.append(c);
                }
            }
            ++i;
        }
        return ending.toString();
    }
}

