local assets=
{
	Asset("ANIM", "anim/queen_claw.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("cutstone")
    anim:SetBuild("queen_claw")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/queen_claw.xml"	
	
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 20
    
    return inst
end

return Prefab( "common/inventory/queen_claw", fn, assets) 
