/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.writers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLDOMWriterImpl
implements XMLStreamWriter {
    private Document ownerDoc = null;
    private Node currentNode = null;
    private Node node = null;
    private NamespaceSupport namespaceContext = null;
    private Method mXmlVersion = null;
    private boolean[] needContextPop = null;
    private StringBuffer stringBuffer = null;
    private int resizeValue = 20;
    private int depth = 0;

    public XMLDOMWriterImpl(DOMResult dOMResult) {
        this.node = dOMResult.getNode();
        if (this.node.getNodeType() == 9) {
            this.ownerDoc = (Document)this.node;
        } else {
            this.ownerDoc = this.node.getOwnerDocument();
            this.currentNode = this.node;
        }
        this.getDLThreeMethods();
        this.stringBuffer = new StringBuffer();
        this.needContextPop = new boolean[this.resizeValue];
        this.namespaceContext = new NamespaceSupport();
    }

    private void getDLThreeMethods() {
        try {
            this.mXmlVersion = this.ownerDoc.getClass().getMethod("setXmlVersion", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.mXmlVersion = null;
        }
        catch (SecurityException securityException) {
            this.mXmlVersion = null;
        }
    }

    public void close() throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }

    public NamespaceContext getNamespaceContext() {
        return null;
    }

    public String getPrefix(String string) throws XMLStreamException {
        String string2 = null;
        if (this.namespaceContext != null) {
            string2 = this.namespaceContext.getPrefix(string);
        }
        return string2;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.namespaceContext.declarePrefix("", string);
        if (!this.needContextPop[this.depth]) {
            this.needContextPop[this.depth] = true;
        }
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        this.namespaceContext.declarePrefix(string, string2);
        if (!this.needContextPop[this.depth]) {
            this.needContextPop[this.depth] = true;
        }
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        if (this.currentNode.getNodeType() != 1) {
            throw new IllegalStateException("Current DOM Node type  is " + this.currentNode.getNodeType() + "and does not allow attributes to be set ");
        }
        Attr attr = this.ownerDoc.createAttribute(string);
        attr.setValue(string2);
        ((Element)this.currentNode).setAttributeNode(attr);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        String string4;
        if (this.currentNode.getNodeType() == 1) {
            string4 = null;
            if (string == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string2 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (this.namespaceContext != null) {
                string4 = this.namespaceContext.getPrefix(string);
            }
            if (string4 == null) {
                throw new XMLStreamException("Namespace URI " + string + "is not bound to any prefix");
            }
        } else {
            throw new IllegalStateException("Current DOM Node type  is " + this.currentNode.getNodeType() + "and does not allow attributes to be set ");
        }
        String string5 = null;
        string5 = string4.equals("") ? string2 : this.getQName(string4, string2);
        Attr attr = this.ownerDoc.createAttributeNS(string, string5);
        attr.setValue(string3);
        ((Element)this.currentNode).setAttributeNode(attr);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (this.currentNode.getNodeType() == 1) {
            if (string2 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (string == null) {
                throw new XMLStreamException("prefix cannot be null");
            }
        } else {
            throw new IllegalStateException("Current DOM Node type  is " + this.currentNode.getNodeType() + "and does not allow attributes to be set ");
        }
        String string5 = null;
        string5 = string.equals("") ? string3 : this.getQName(string, string3);
        Attr attr = this.ownerDoc.createAttributeNS(string2, string5);
        attr.setValue(string4);
        ((Element)this.currentNode).setAttributeNodeNS(attr);
    }

    public void writeCData(String string) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("CDATA cannot be null");
        }
        CDATASection cDATASection = this.ownerDoc.createCDATASection(string);
        this.getNode().appendChild(cDATASection);
    }

    public void writeCharacters(String string) throws XMLStreamException {
        Text text = this.ownerDoc.createTextNode(string);
        this.currentNode.appendChild(text);
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        Text text = this.ownerDoc.createTextNode(new String(cArray, n, n2));
        this.currentNode.appendChild(text);
    }

    public void writeComment(String string) throws XMLStreamException {
        Comment comment = this.ownerDoc.createComment(string);
        this.getNode().appendChild(comment);
    }

    public void writeDTD(String string) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (this.currentNode.getNodeType() != 1) {
            throw new IllegalStateException("Current DOM Node type  is " + this.currentNode.getNodeType() + "and does not allow attributes to be set ");
        }
        String string2 = "xmlns";
        ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", string2, string);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        if (this.ownerDoc != null) {
            Element element = this.ownerDoc.createElement(string);
            if (this.currentNode != null) {
                this.currentNode.appendChild(element);
            } else {
                this.ownerDoc.appendChild(element);
            }
        }
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        if (this.ownerDoc != null) {
            String string3 = null;
            String string4 = null;
            if (string == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string2 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (this.namespaceContext != null) {
                string4 = this.namespaceContext.getPrefix(string);
            }
            if (string4 == null) {
                throw new XMLStreamException("Namespace URI " + string + "is not bound to any prefix");
            }
            string3 = "".equals(string4) ? string2 : this.getQName(string4, string2);
            Element element = this.ownerDoc.createElementNS(string, string3);
            if (this.currentNode != null) {
                this.currentNode.appendChild(element);
            } else {
                this.ownerDoc.appendChild(element);
            }
        }
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        if (this.ownerDoc != null) {
            if (string3 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string2 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (string == null) {
                throw new XMLStreamException("Prefix cannot be null");
            }
            String string4 = null;
            string4 = "".equals(string) ? string2 : this.getQName(string, string2);
            Element element = this.ownerDoc.createElementNS(string3, string4);
            if (this.currentNode != null) {
                this.currentNode.appendChild(element);
            } else {
                this.ownerDoc.appendChild(element);
            }
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        this.currentNode = null;
        for (int i = 0; i < this.depth; ++i) {
            if (this.needContextPop[this.depth]) {
                this.needContextPop[this.depth] = false;
                this.namespaceContext.popContext();
            }
            --this.depth;
        }
        this.depth = 0;
    }

    public void writeEndElement() throws XMLStreamException {
        Node node = this.currentNode.getParentNode();
        this.currentNode = this.currentNode.getNodeType() == 9 ? null : node;
        if (this.needContextPop[this.depth]) {
            this.needContextPop[this.depth] = false;
            this.namespaceContext.popContext();
        }
        --this.depth;
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        EntityReference entityReference = this.ownerDoc.createEntityReference(string);
        this.currentNode.appendChild(entityReference);
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("prefix cannot be null");
        }
        if (string2 == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        String string3 = null;
        string3 = string.equals("") ? "xmlns" : this.getQName("xmlns", string);
        ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("Target cannot be null");
        }
        ProcessingInstruction processingInstruction = this.ownerDoc.createProcessingInstruction(string, "");
        this.currentNode.appendChild(processingInstruction);
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("Target cannot be null");
        }
        ProcessingInstruction processingInstruction = this.ownerDoc.createProcessingInstruction(string, string2);
        this.currentNode.appendChild(processingInstruction);
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            if (this.mXmlVersion != null) {
                this.mXmlVersion.invoke(this.ownerDoc, "1.0");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLStreamException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XMLStreamException(invocationTargetException);
        }
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        try {
            if (this.mXmlVersion != null) {
                this.mXmlVersion.invoke(this.ownerDoc, string);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLStreamException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XMLStreamException(invocationTargetException);
        }
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        try {
            if (this.mXmlVersion != null) {
                this.mXmlVersion.invoke(this.ownerDoc, string2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLStreamException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XMLStreamException(invocationTargetException);
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        if (this.ownerDoc != null) {
            Element element = this.ownerDoc.createElement(string);
            if (this.currentNode != null) {
                this.currentNode.appendChild(element);
            } else {
                this.ownerDoc.appendChild(element);
            }
            this.currentNode = element;
        }
        if (this.needContextPop[this.depth]) {
            this.namespaceContext.pushContext();
        }
        ++this.depth;
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        if (this.ownerDoc != null) {
            String string3 = null;
            String string4 = null;
            if (string == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string2 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (this.namespaceContext != null) {
                string4 = this.namespaceContext.getPrefix(string);
            }
            if (string4 == null) {
                throw new XMLStreamException("Namespace URI " + string + "is not bound to any prefix");
            }
            string3 = "".equals(string4) ? string2 : this.getQName(string4, string2);
            Element element = this.ownerDoc.createElementNS(string, string3);
            if (this.currentNode != null) {
                this.currentNode.appendChild(element);
            } else {
                this.ownerDoc.appendChild(element);
            }
            this.currentNode = element;
        }
        if (this.needContextPop[this.depth]) {
            this.namespaceContext.pushContext();
        }
        ++this.depth;
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        if (this.ownerDoc != null) {
            String string4 = null;
            if (string3 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string2 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (string == null) {
                throw new XMLStreamException("Prefix cannot be null");
            }
            string4 = string.equals("") ? string2 : this.getQName(string, string2);
            Element element = this.ownerDoc.createElementNS(string3, string4);
            if (this.currentNode != null) {
                this.currentNode.appendChild(element);
            } else {
                this.ownerDoc.appendChild(element);
            }
            this.currentNode = element;
            if (this.needContextPop[this.depth]) {
                this.namespaceContext.pushContext();
            }
            ++this.depth;
        }
    }

    private String getQName(String string, String string2) {
        this.stringBuffer.setLength(0);
        this.stringBuffer.append(string);
        this.stringBuffer.append(":");
        this.stringBuffer.append(string2);
        return this.stringBuffer.toString();
    }

    private Node getNode() {
        if (this.currentNode == null) {
            return this.ownerDoc;
        }
        return this.currentNode;
    }
}

