/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCookieStore
implements CookieStore {
    private List<HttpCookie> cookieJar = new ArrayList<HttpCookie>();
    private Map<String, List<HttpCookie>> domainIndex = new HashMap<String, List<HttpCookie>>();
    private Map<URI, List<HttpCookie>> uriIndex = new HashMap<URI, List<HttpCookie>>();
    private ReentrantLock lock = new ReentrantLock(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(URI uRI, HttpCookie httpCookie) {
        if (httpCookie == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        try {
            this.cookieJar.remove(httpCookie);
            if (httpCookie.getMaxAge() != 0L) {
                this.cookieJar.add(httpCookie);
                this.addIndex(this.domainIndex, httpCookie.getDomain(), httpCookie);
                this.addIndex(this.uriIndex, this.getEffectiveURI(uRI), httpCookie);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> get(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri is null");
        }
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        this.lock.lock();
        try {
            this.getInternal(arrayList, this.domainIndex, new DomainComparator(uRI.getHost()));
            this.getInternal(arrayList, this.uriIndex, this.getEffectiveURI(uRI));
        }
        finally {
            this.lock.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> getCookies() {
        List<HttpCookie> list;
        this.lock.lock();
        try {
            Iterator<HttpCookie> iterator = this.cookieJar.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().hasExpired()) continue;
                iterator.remove();
            }
        }
        finally {
            list = Collections.unmodifiableList(this.cookieJar);
            this.lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getURIs() {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        this.lock.lock();
        try {
            Iterator<URI> iterator = this.uriIndex.keySet().iterator();
            while (iterator.hasNext()) {
                URI uRI = iterator.next();
                List<HttpCookie> list = this.uriIndex.get(uRI);
                if (list != null && list.size() != 0) continue;
                iterator.remove();
            }
        }
        finally {
            arrayList.addAll(this.uriIndex.keySet());
            this.lock.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(URI uRI, HttpCookie httpCookie) {
        if (httpCookie == null) {
            throw new NullPointerException("cookie is null");
        }
        boolean bl = false;
        this.lock.lock();
        try {
            bl = this.cookieJar.remove(httpCookie);
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll() {
        this.lock.lock();
        try {
            this.cookieJar.clear();
            this.domainIndex.clear();
            this.uriIndex.clear();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private <T> void getInternal(List<HttpCookie> list, Map<T, List<HttpCookie>> map, Comparable<T> comparable) {
        for (T t : map.keySet()) {
            List<HttpCookie> list2;
            if (comparable.compareTo(t) != 0 || (list2 = map.get(t)) == null) continue;
            Iterator<HttpCookie> iterator = list2.iterator();
            while (iterator.hasNext()) {
                HttpCookie httpCookie = iterator.next();
                if (this.cookieJar.indexOf(httpCookie) != -1) {
                    if (!httpCookie.hasExpired()) {
                        if (list.contains(httpCookie)) continue;
                        list.add(httpCookie);
                        continue;
                    }
                    iterator.remove();
                    this.cookieJar.remove(httpCookie);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private <T> void addIndex(Map<T, List<HttpCookie>> map, T t, HttpCookie httpCookie) {
        if (t != null) {
            List<HttpCookie> list = map.get(t);
            if (list != null) {
                list.remove(httpCookie);
                list.add(httpCookie);
            } else {
                list = new ArrayList<HttpCookie>();
                list.add(httpCookie);
                map.put(t, list);
            }
        }
    }

    private URI getEffectiveURI(URI uRI) {
        URI uRI2 = null;
        try {
            uRI2 = new URI(uRI.getScheme(), uRI.getAuthority(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI2 = uRI;
        }
        return uRI2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DomainComparator
    implements Comparable<String> {
        String host = null;

        public DomainComparator(String string) {
            this.host = string;
        }

        @Override
        public int compareTo(String string) {
            if (HttpCookie.domainMatches(string, this.host)) {
                return 0;
            }
            return -1;
        }
    }
}

