/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.FVDCodeBaseImpl;
import com.sun.corba.se.impl.io.IIOPInputStream;
import com.sun.corba.se.impl.io.IIOPOutputStream;
import com.sun.corba.se.impl.io.ObjectStreamClass;
import com.sun.corba.se.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.UtilSystemException;
import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.impl.util.Utility;
import com.sun.org.omg.SendingContext.CodeBase;
import com.sun.org.omg.SendingContext.CodeBaseHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.RunTime;

public class ValueHandlerImpl
implements ValueHandlerMultiFormat {
    public static final String FORMAT_VERSION_PROPERTY = "com.sun.CORBA.MaxStreamFormatVersion";
    private static final byte MAX_SUPPORTED_FORMAT_VERSION = 2;
    private static final byte STREAM_FORMAT_VERSION_1 = 1;
    private static final byte MAX_STREAM_FORMAT_VERSION = ValueHandlerImpl.getMaxStreamFormatVersion();
    public static final short kRemoteType = 0;
    public static final short kAbstractType = 1;
    public static final short kValueType = 2;
    private Hashtable inputStreamPairs = null;
    private Hashtable outputStreamPairs = null;
    private CodeBase codeBase = null;
    private boolean useHashtables = true;
    private boolean isInputStream = true;
    private IIOPOutputStream outputStreamBridge = null;
    private IIOPInputStream inputStreamBridge = null;
    private OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
    private UtilSystemException utilWrapper = UtilSystemException.get("rpc.encoding");

    private static byte getMaxStreamFormatVersion() {
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    return System.getProperty(ValueHandlerImpl.FORMAT_VERSION_PROPERTY);
                }
            });
            if (string == null) {
                return 2;
            }
            byte by = Byte.parseByte(string);
            if (by < 1 || by > 2) {
                throw new ExceptionInInitializerError("Invalid stream format version: " + by + ".  Valid range is 1 through " + 2);
            }
            return by;
        }
        catch (Exception exception) {
            ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError(exception);
            exceptionInInitializerError.initCause(exception);
            throw exceptionInInitializerError;
        }
    }

    public byte getMaximumStreamFormatVersion() {
        return MAX_STREAM_FORMAT_VERSION;
    }

    public void writeValue(org.omg.CORBA.portable.OutputStream outputStream, Serializable serializable, byte by) {
        if (by == 2) {
            if (!(outputStream instanceof ValueOutputStream)) {
                throw this.omgWrapper.notAValueoutputstream();
            }
        } else if (by != 1) {
            throw this.omgWrapper.invalidStreamFormatVersion(new Integer(by));
        }
        this.writeValueWithVersion(outputStream, serializable, by);
    }

    public ValueHandlerImpl() {
    }

    public ValueHandlerImpl(boolean bl) {
        this();
        this.useHashtables = false;
        this.isInputStream = bl;
    }

    public void writeValue(org.omg.CORBA.portable.OutputStream outputStream, Serializable serializable) {
        this.writeValueWithVersion(outputStream, serializable, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeValueWithVersion(org.omg.CORBA.portable.OutputStream outputStream, Serializable serializable, byte by) {
        OutputStream outputStream2 = (OutputStream)outputStream;
        if (!this.useHashtables) {
            if (this.outputStreamBridge == null) {
                this.outputStreamBridge = this.createOutputStream();
                this.outputStreamBridge.setOrbStream(outputStream2);
            }
            try {
                this.outputStreamBridge.increaseRecursionDepth();
                this.writeValueInternal(this.outputStreamBridge, outputStream2, serializable, by);
            }
            finally {
                this.outputStreamBridge.decreaseRecursionDepth();
            }
            return;
        }
        IIOPOutputStream iIOPOutputStream = null;
        if (this.outputStreamPairs == null) {
            this.outputStreamPairs = new Hashtable();
        }
        if ((iIOPOutputStream = (IIOPOutputStream)this.outputStreamPairs.get(outputStream)) == null) {
            iIOPOutputStream = this.createOutputStream();
            iIOPOutputStream.setOrbStream(outputStream2);
            this.outputStreamPairs.put(outputStream, iIOPOutputStream);
        }
        try {
            iIOPOutputStream.increaseRecursionDepth();
            this.writeValueInternal(iIOPOutputStream, outputStream2, serializable, by);
        }
        finally {
            if (iIOPOutputStream.decreaseRecursionDepth() == 0) {
                this.outputStreamPairs.remove(outputStream);
            }
        }
    }

    private void writeValueInternal(IIOPOutputStream iIOPOutputStream, OutputStream outputStream, Serializable serializable, byte by) {
        Class<?> clazz = serializable.getClass();
        if (clazz.isArray()) {
            this.write_Array(outputStream, serializable, clazz.getComponentType());
        } else {
            iIOPOutputStream.simpleWriteObject(serializable, by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable readValue(org.omg.CORBA.portable.InputStream inputStream, int n, Class clazz, String string, RunTime runTime) {
        CodeBase codeBase = CodeBaseHelper.narrow(runTime);
        InputStream inputStream2 = (InputStream)inputStream;
        if (!this.useHashtables) {
            if (this.inputStreamBridge == null) {
                this.inputStreamBridge = this.createInputStream();
                this.inputStreamBridge.setOrbStream(inputStream2);
                this.inputStreamBridge.setSender(codeBase);
                this.inputStreamBridge.setValueHandler(this);
            }
            Serializable serializable = null;
            try {
                this.inputStreamBridge.increaseRecursionDepth();
                serializable = this.readValueInternal(this.inputStreamBridge, inputStream2, n, clazz, string, codeBase);
            }
            finally {
                if (this.inputStreamBridge.decreaseRecursionDepth() == 0) {
                    // empty if block
                }
            }
            return serializable;
        }
        IIOPInputStream iIOPInputStream = null;
        if (this.inputStreamPairs == null) {
            this.inputStreamPairs = new Hashtable();
        }
        if ((iIOPInputStream = (IIOPInputStream)this.inputStreamPairs.get(inputStream)) == null) {
            iIOPInputStream = this.createInputStream();
            iIOPInputStream.setOrbStream(inputStream2);
            iIOPInputStream.setSender(codeBase);
            iIOPInputStream.setValueHandler(this);
            this.inputStreamPairs.put(inputStream, iIOPInputStream);
        }
        Serializable serializable = null;
        try {
            iIOPInputStream.increaseRecursionDepth();
            serializable = this.readValueInternal(iIOPInputStream, inputStream2, n, clazz, string, codeBase);
        }
        finally {
            if (iIOPInputStream.decreaseRecursionDepth() == 0) {
                this.inputStreamPairs.remove(inputStream);
            }
        }
        return serializable;
    }

    private Serializable readValueInternal(IIOPInputStream iIOPInputStream, InputStream inputStream, int n, Class clazz, String string, CodeBase codeBase) {
        Serializable serializable = null;
        if (clazz == null) {
            if (this.isArray(string)) {
                this.read_Array(iIOPInputStream, inputStream, null, codeBase, n);
            } else {
                iIOPInputStream.simpleSkipObject(string, codeBase);
            }
            return serializable;
        }
        serializable = clazz.isArray() ? (Serializable)this.read_Array(iIOPInputStream, inputStream, clazz, codeBase, n) : (Serializable)iIOPInputStream.simpleReadObject(clazz, string, codeBase, n);
        return serializable;
    }

    public String getRMIRepositoryID(Class clazz) {
        return RepositoryId.createForJavaType(clazz);
    }

    public boolean isCustomMarshaled(Class clazz) {
        return ObjectStreamClass.lookup(clazz).isCustomMarshaled();
    }

    public RunTime getRunTimeCodeBase() {
        if (this.codeBase != null) {
            return this.codeBase;
        }
        this.codeBase = new FVDCodeBaseImpl();
        FVDCodeBaseImpl fVDCodeBaseImpl = (FVDCodeBaseImpl)this.codeBase;
        fVDCodeBaseImpl.setValueHandler(this);
        return this.codeBase;
    }

    public boolean useFullValueDescription(Class clazz, String string) throws IOException {
        return RepositoryId.useFullValueDescription(clazz, string);
    }

    public String getClassName(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getClassName();
    }

    public Class getClassFromType(String string) throws ClassNotFoundException {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getClassFromType();
    }

    public Class getAnyClassFromType(String string) throws ClassNotFoundException {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getAnyClassFromType();
    }

    public String createForAnyType(Class clazz) {
        return RepositoryId.createForAnyType(clazz);
    }

    public String getDefinedInId(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getDefinedInId();
    }

    public String getUnqualifiedName(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getUnqualifiedName();
    }

    public String getSerialVersionUID(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getSerialVersionUID();
    }

    public boolean isAbstractBase(Class clazz) {
        return RepositoryId.isAbstractBase(clazz);
    }

    public boolean isSequence(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.isSequence();
    }

    public Serializable writeReplace(Serializable serializable) {
        return ObjectStreamClass.lookup(serializable.getClass()).writeReplace(serializable);
    }

    protected void writeCharArray(OutputStream outputStream, char[] cArray, int n, int n2) {
        outputStream.write_wchar_array(cArray, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write_Array(OutputStream outputStream, Serializable serializable, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])serializable;
                int n = nArray.length;
                outputStream.write_ulong(n);
                outputStream.write_long_array(nArray, 0, n);
                return;
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])serializable;
                int n = byArray.length;
                outputStream.write_ulong(n);
                outputStream.write_octet_array(byArray, 0, n);
                return;
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])serializable;
                int n = lArray.length;
                outputStream.write_ulong(n);
                outputStream.write_longlong_array(lArray, 0, n);
                return;
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])serializable;
                int n = fArray.length;
                outputStream.write_ulong(n);
                outputStream.write_float_array(fArray, 0, n);
                return;
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])serializable;
                int n = dArray.length;
                outputStream.write_ulong(n);
                outputStream.write_double_array(dArray, 0, n);
                return;
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])serializable;
                int n = sArray.length;
                outputStream.write_ulong(n);
                outputStream.write_short_array(sArray, 0, n);
                return;
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])serializable;
                int n = cArray.length;
                outputStream.write_ulong(n);
                this.writeCharArray(outputStream, cArray, 0, n);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new Error("Invalid primitive type : " + serializable.getClass().getName());
                boolean[] blArray = (boolean[])serializable;
                int n = blArray.length;
                outputStream.write_ulong(n);
                outputStream.write_boolean_array(blArray, 0, n);
            }
            return;
        } else if (clazz == java.lang.Object.class) {
            java.lang.Object[] objectArray = (java.lang.Object[])serializable;
            int n = objectArray.length;
            outputStream.write_ulong(n);
            for (int i = 0; i < n; ++i) {
                Util.writeAny(outputStream, objectArray[i]);
            }
            return;
        } else {
            java.lang.Object[] objectArray = (java.lang.Object[])serializable;
            int n = objectArray.length;
            outputStream.write_ulong(n);
            int n2 = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if (Remote.class.isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (Object.class.isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n2 = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n2 = 1;
                }
            }
            block8: for (int i = 0; i < n; ++i) {
                switch (n2) {
                    case 0: {
                        Util.writeRemoteObject(outputStream, objectArray[i]);
                        continue block8;
                    }
                    case 1: {
                        Util.writeAbstractObject(outputStream, objectArray[i]);
                        continue block8;
                    }
                    case 2: {
                        try {
                            outputStream.write_value((Serializable)objectArray[i]);
                            continue block8;
                        }
                        catch (ClassCastException classCastException) {
                            if (objectArray[i] instanceof Serializable) {
                                throw classCastException;
                            }
                            Utility.throwNotSerializableForCorba(objectArray[i].getClass().getName());
                        }
                    }
                }
            }
        }
    }

    protected void readCharArray(InputStream inputStream, char[] cArray, int n, int n2) {
        inputStream.read_wchar_array(cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.lang.Object read_Array(IIOPInputStream iIOPInputStream, InputStream inputStream, Class clazz, CodeBase codeBase, int n) {
        try {
            Class clazz2;
            int n2 = inputStream.read_ulong();
            if (clazz == null) {
                for (int i = 0; i < n2; ++i) {
                    inputStream.read_value();
                }
                java.lang.Object var8_10 = null;
                return var8_10;
            }
            Class clazz3 = clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz2 == Integer.TYPE) {
                    int[] nArray = new int[n2];
                    inputStream.read_long_array(nArray, 0, n2);
                    Serializable serializable = (Serializable)nArray;
                    return serializable;
                }
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = new byte[n2];
                    inputStream.read_octet_array(byArray, 0, n2);
                    Serializable serializable = (Serializable)byArray;
                    return serializable;
                }
                if (clazz2 == Long.TYPE) {
                    long[] lArray = new long[n2];
                    inputStream.read_longlong_array(lArray, 0, n2);
                    Serializable serializable = (Serializable)lArray;
                    return serializable;
                }
                if (clazz2 == Float.TYPE) {
                    float[] fArray = new float[n2];
                    inputStream.read_float_array(fArray, 0, n2);
                    Serializable serializable = (Serializable)fArray;
                    return serializable;
                }
                if (clazz2 == Double.TYPE) {
                    double[] dArray = new double[n2];
                    inputStream.read_double_array(dArray, 0, n2);
                    Serializable serializable = (Serializable)dArray;
                    return serializable;
                }
                if (clazz2 == Short.TYPE) {
                    short[] sArray = new short[n2];
                    inputStream.read_short_array(sArray, 0, n2);
                    Serializable serializable = (Serializable)sArray;
                    return serializable;
                }
                if (clazz2 == Character.TYPE) {
                    char[] cArray = new char[n2];
                    this.readCharArray(inputStream, cArray, 0, n2);
                    Serializable serializable = (Serializable)cArray;
                    return serializable;
                }
                if (clazz2 == Boolean.TYPE) {
                    boolean[] blArray = new boolean[n2];
                    inputStream.read_boolean_array(blArray, 0, n2);
                    Serializable serializable = (Serializable)blArray;
                    return serializable;
                }
                throw new Error("Invalid primitive componentType : " + clazz.getName());
            }
            if (clazz2 == java.lang.Object.class) {
                java.lang.Object object;
                java.lang.Object[] objectArray = (java.lang.Object[])Array.newInstance(clazz2, n2);
                iIOPInputStream.activeRecursionMgr.addObject(n, objectArray);
                for (int i = 0; i < n2; ++i) {
                    object = null;
                    try {
                        object = Util.readAny(inputStream);
                    }
                    catch (IndirectionException indirectionException) {
                        try {
                            object = iIOPInputStream.activeRecursionMgr.getObject(indirectionException.offset);
                        }
                        catch (IOException iOException) {
                            throw this.utilWrapper.invalidIndirection(iOException, (java.lang.Object)new Integer(indirectionException.offset));
                        }
                    }
                    objectArray[i] = object;
                }
                object = (Serializable)objectArray;
                return object;
            }
            java.lang.Object[] objectArray = (java.lang.Object[])Array.newInstance(clazz2, n2);
            iIOPInputStream.activeRecursionMgr.addObject(n, objectArray);
            int n3 = 2;
            boolean bl = false;
            if (clazz2.isInterface()) {
                boolean bl2 = false;
                if (Remote.class.isAssignableFrom(clazz2)) {
                    n3 = 0;
                    bl2 = true;
                } else if (Object.class.isAssignableFrom(clazz2)) {
                    n3 = 0;
                    bl2 = true;
                } else if (RepositoryId.isAbstractBase(clazz2)) {
                    n3 = 1;
                    bl2 = true;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz2)) {
                    n3 = 1;
                }
                if (bl2) {
                    try {
                        Class clazz4;
                        String string = Util.getCodebase(clazz2);
                        String string2 = RepositoryId.createForAnyType(clazz2);
                        clazz3 = clazz4 = Utility.loadStubClass(string2, string, clazz2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            for (int i = 0; i < n2; ++i) {
                try {
                    switch (n3) {
                        case 0: {
                            if (!bl) {
                                objectArray[i] = inputStream.read_Object(clazz3);
                                break;
                            }
                            objectArray[i] = Utility.readObjectAndNarrow(inputStream, clazz3);
                            break;
                        }
                        case 1: {
                            if (!bl) {
                                objectArray[i] = inputStream.read_abstract_interface(clazz3);
                                break;
                            }
                            objectArray[i] = Utility.readAbstractAndNarrow(inputStream, clazz3);
                            break;
                        }
                        case 2: {
                            objectArray[i] = inputStream.read_value(clazz3);
                        }
                    }
                    continue;
                }
                catch (IndirectionException indirectionException) {
                    try {
                        objectArray[i] = iIOPInputStream.activeRecursionMgr.getObject(indirectionException.offset);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw this.utilWrapper.invalidIndirection(iOException, (java.lang.Object)new Integer(indirectionException.offset));
                    }
                }
            }
            Serializable serializable = (Serializable)objectArray;
            return serializable;
        }
        finally {
            iIOPInputStream.activeRecursionMgr.removeObject(n);
        }
    }

    private boolean isArray(String string) {
        return RepositoryId.cache.getId(string).isSequence();
    }

    protected String getOutputStreamClassName() {
        return "com.sun.corba.se.impl.io.IIOPOutputStream";
    }

    private IIOPOutputStream createOutputStream() {
        return (IIOPOutputStream)AccessController.doPrivileged(new StreamFactory(this.getOutputStreamClassName()));
    }

    protected String getInputStreamClassName() {
        return "com.sun.corba.se.impl.io.IIOPInputStream";
    }

    private IIOPInputStream createInputStream() {
        return (IIOPInputStream)AccessController.doPrivileged(new StreamFactory(this.getInputStreamClassName()));
    }

    protected TCKind getJavaCharTCKind() {
        return TCKind.tk_wchar;
    }

    private static final class StreamFactory
    implements PrivilegedAction {
        private String className;

        public StreamFactory(String string) {
            this.className = string;
        }

        public java.lang.Object run() {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                Class<?> clazz = classLoader.loadClass(this.className);
                return clazz.newInstance();
            }
            catch (Throwable throwable) {
                InternalError internalError = new InternalError("Error loading " + this.className);
                internalError.initCause(throwable);
                throw internalError;
            }
        }
    }
}

