/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.InternetHeaders;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.internal.ws.message.stream.StreamAttachment;
import com.sun.xml.internal.ws.util.ASCIIUtility;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeMultipartParser {
    private final InputStream in;
    private final String start;
    private final byte[] boundaryBytes;
    private final BitSet lastPartFound = new BitSet(1);
    private int b = 0;
    private final int[] bcs = new int[256];
    private int[] gss;
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[4096];
    private byte[] prevBuffer = new byte[4096];
    private boolean firstPart = true;
    private final Map<String, StreamAttachment> attachments = new HashMap<String, StreamAttachment>();
    private StreamAttachment root;
    private int cidCounter = 0;

    public MimeMultipartParser(InputStream inputStream, String string) {
        try {
            ContentType contentType = new ContentType(string);
            String string2 = contentType.getParameter("boundary");
            if (string2 == null || string2.equals("")) {
                throw new WebServiceException("MIME boundary parameter not found" + string);
            }
            String string3 = "--" + string2;
            this.boundaryBytes = ASCIIUtility.getBytes(string3);
            this.start = contentType.getParameter("start");
        }
        catch (ParseException parseException) {
            throw new WebServiceException(parseException);
        }
        this.in = !inputStream.markSupported() ? new BufferedInputStream(inputStream) : inputStream;
    }

    @Nullable
    public StreamAttachment getRootPart() {
        if (this.root != null) {
            return this.root;
        }
        while (!this.lastBodyPartFound() && this.b != -1 && this.root == null) {
            this.getNextPart();
        }
        return this.root;
    }

    @NotNull
    public Map<String, StreamAttachment> getAttachmentParts() {
        while (!this.lastBodyPartFound() && this.b != -1) {
            this.getNextPart();
        }
        return this.attachments;
    }

    @Nullable
    public StreamAttachment getAttachmentPart(String string) throws IOException {
        StreamAttachment streamAttachment = this.attachments.get(string);
        if (streamAttachment != null) {
            return streamAttachment;
        }
        while (!this.lastBodyPartFound() && this.b != -1) {
            streamAttachment = this.getNextPart();
            String string2 = streamAttachment.getContentId();
            if (string2 == null || !string2.equals(string)) continue;
            return streamAttachment;
        }
        return null;
    }

    private StreamAttachment getNextPart() {
        assert (!this.lastBodyPartFound());
        try {
            String string;
            InternetHeaders internetHeaders;
            String[] stringArray;
            if (this.firstPart) {
                this.compileBoundaryPattern();
                if (!this.skipPreamble()) {
                    throw new WebServiceException("Missing Start Boundary, or boundary does not start on a new line");
                }
            }
            String string2 = (stringArray = (internetHeaders = new InternetHeaders(this.in)).getHeader("content-type")) != null ? stringArray[0] : "application/octet-stream";
            String[] stringArray2 = internetHeaders.getHeader("content-id");
            String string3 = string = stringArray2 != null ? stringArray2[0] : null;
            if (string != null && string.length() > 2 && string3.charAt(0) == '<') {
                string3 = string.substring(1, string.length() - 1);
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            this.b = this.readBody(byteArrayBuffer);
            StreamAttachment streamAttachment = new StreamAttachment(byteArrayBuffer, string3, string2);
            if (this.start == null && this.firstPart) {
                this.root = streamAttachment;
            } else if (string != null && this.start != null && this.start.equals(string)) {
                this.root = streamAttachment;
            } else if (string3 != null) {
                this.attachments.put(string3, streamAttachment);
            } else {
                ++this.cidCounter;
                this.attachments.put("" + this.cidCounter, streamAttachment);
            }
            this.firstPart = false;
            return streamAttachment;
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        catch (MessagingException messagingException) {
            throw new WebServiceException(messagingException);
        }
    }

    private int readBody(ByteArrayBuffer byteArrayBuffer) throws IOException {
        if (!this.findMimeBody(byteArrayBuffer)) {
            throw new WebServiceException("Missing boundary delimitier ");
        }
        return this.b;
    }

    private boolean findMimeBody(ByteArrayBuffer byteArrayBuffer) throws IOException {
        int n = this.boundaryBytes.length;
        int n2 = n - 1;
        int n3 = 0;
        boolean bl = true;
        BitSet bitSet = new BitSet(1);
        while (true) {
            int n4;
            int n5;
            this.in.mark(n);
            if (!bl) {
                byte[] byArray = this.prevBuffer;
                this.prevBuffer = this.buffer;
                this.buffer = byArray;
            }
            if ((n5 = this.readNext(this.in, n, bitSet)) == -1) {
                this.b = -1;
                if (n3 == n) {
                    byteArrayBuffer.write(this.prevBuffer, 0, n3);
                }
                return true;
            }
            if (n5 < n) {
                byteArrayBuffer.write(this.buffer, 0, n5);
                this.b = -1;
                return true;
            }
            for (n4 = n2; n4 >= 0 && this.buffer[n4] == this.boundaryBytes[n4]; --n4) {
            }
            if (n4 < 0) {
                if (n3 > 0) {
                    if (n3 <= 2) {
                        String string = new String(this.prevBuffer, 0, n3);
                        if (!"\n".equals(string) && !"\r\n".equals(string)) {
                            throw new WebServiceException("Boundary characters encountered in part Body without a preceeding CRLF");
                        }
                    } else if (n3 > 2) {
                        if (this.prevBuffer[n3 - 2] == 13 && this.prevBuffer[n3 - 1] == 10) {
                            byteArrayBuffer.write(this.prevBuffer, 0, n3 - 2);
                        } else if (this.prevBuffer[n3 - 1] == 10) {
                            byteArrayBuffer.write(this.prevBuffer, 0, n3 - 1);
                        } else {
                            throw new WebServiceException("Boundary characters encountered in part Body without a preceeding CRLF");
                        }
                    }
                }
                if (!this.skipLWSPAndCRLF(this.in)) {
                    // empty if block
                }
                return true;
            }
            if (n3 > 0) {
                if (this.prevBuffer[n3 - 1] == 13) {
                    if (this.buffer[0] == 10) {
                        int n6;
                        for (n6 = n2 - 1; n6 > 0 && this.buffer[n6 + 1] == this.boundaryBytes[n6]; --n6) {
                        }
                        if (n6 == 0) {
                            byteArrayBuffer.write(this.prevBuffer, 0, n3 - 1);
                        } else {
                            byteArrayBuffer.write(this.prevBuffer, 0, n3);
                        }
                    } else {
                        byteArrayBuffer.write(this.prevBuffer, 0, n3);
                    }
                } else {
                    byteArrayBuffer.write(this.prevBuffer, 0, n3);
                }
            }
            n3 = Math.max(n4 + 1 - this.bcs[this.buffer[n4] & 0x7F], this.gss[n4]);
            this.in.reset();
            this.in.skip(n3);
            if (!bl) continue;
            bl = false;
        }
    }

    private boolean lastBodyPartFound() {
        return this.lastPartFound.get(0);
    }

    private void compileBoundaryPattern() {
        int n;
        int n2 = this.boundaryBytes.length;
        for (n = 0; n < n2; ++n) {
            this.bcs[this.boundaryBytes[n]] = n + 1;
        }
        this.gss = new int[n2];
        block1: for (n = n2; n > 0; --n) {
            int n3;
            for (n3 = n2 - 1; n3 >= n; --n3) {
                if (this.boundaryBytes[n3] != this.boundaryBytes[n3 - n]) continue block1;
                this.gss[n3 - 1] = n;
            }
            while (n3 > 0) {
                this.gss[--n3] = n;
            }
        }
        this.gss[n2 - 1] = 1;
    }

    private boolean skipPreamble() throws IOException {
        if (!this.findBoundary()) {
            return false;
        }
        if (this.lastPartFound.get(0)) {
            throw new WebServiceException("Found closing boundary delimiter while trying to skip preamble");
        }
        return true;
    }

    private boolean findBoundary() throws IOException {
        int n = this.boundaryBytes.length;
        int n2 = n - 1;
        BitSet bitSet = new BitSet(1);
        while (true) {
            int n3;
            this.in.mark(n);
            this.readNext(this.in, n, bitSet);
            if (bitSet.get(0)) {
                return false;
            }
            for (n3 = n2; n3 >= 0 && this.buffer[n3] == this.boundaryBytes[n3]; --n3) {
            }
            if (n3 < 0) {
                if (!this.skipLWSPAndCRLF(this.in)) {
                    throw new WebServiceException("Boundary does not terminate with CRLF");
                }
                return true;
            }
            int n4 = Math.max(n3 + 1 - this.bcs[this.buffer[n3] & 0x7F], this.gss[n3]);
            this.in.reset();
            this.in.skip(n4);
        }
    }

    private boolean skipLWSPAndCRLF(InputStream inputStream) throws IOException {
        this.b = inputStream.read();
        if (this.b == 10) {
            return true;
        }
        if (this.b == 13) {
            this.b = inputStream.read();
            if (this.b == 10) {
                return true;
            }
            throw new WebServiceException("transport padding after a Mime Boundary  should end in a CRLF, found CR only");
        }
        if (this.b == 45) {
            this.b = inputStream.read();
            if (this.b != 45) {
                throw new WebServiceException("Unexpected singular '-' character after Mime Boundary");
            }
            this.lastPartFound.flip(0);
            this.b = inputStream.read();
        }
        while (this.b != -1 && (this.b == 32 || this.b == 9)) {
            this.b = inputStream.read();
            if (this.b != 13) continue;
            this.b = inputStream.read();
            if (this.b != 10) continue;
            return true;
        }
        if (this.b == -1) {
            if (!this.lastPartFound.get(0)) {
                throw new WebServiceException("End of Multipart Stream before encountering  closing boundary delimiter");
            }
            return true;
        }
        return false;
    }

    private int readNext(InputStream inputStream, int n, BitSet bitSet) throws IOException {
        int n2 = inputStream.read(this.buffer, 0, n);
        if (n2 == -1) {
            bitSet.flip(0);
        } else if (n2 < n) {
            int n3;
            for (n3 = n2; n3 < n; ++n3) {
                int n4 = inputStream.read();
                if (n4 == -1) {
                    bitSet.flip(0);
                    break;
                }
                this.buffer[n3] = (byte)n4;
            }
            n2 = n3;
        }
        return n2;
    }
}

