/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.DataBufferInt;
import java.awt.peer.WindowPeer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.WToolkit;

public class WWindowPeer
extends WPanelPeer
implements WindowPeer {
    private static final DebugHelper dbg = DebugHelper.create(WWindowPeer.class);
    private static final Logger log = Logger.getLogger("sun.awt.windows.WWindowPeer");
    private WWindowPeer modalBlocker = null;
    private static Field peerField;
    private static Method getWindowsMethod;
    static Vector allWindows;
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;

    private static native void initIDs();

    protected void disposeImpl() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).removeDisplayChangedListener(this);
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public void toFront() {
        this.updateFocusableWindowState();
        this._toFront();
    }

    native void _toFront();

    public native void toBack();

    public native void setAlwaysOnTopNative(boolean var1);

    public void setAlwaysOnTop(boolean bl) {
        if (bl && ((Window)this.target).isVisible() || !bl) {
            this.setAlwaysOnTopNative(bl);
        }
    }

    public void updateFocusableWindowState() {
        this.setFocusableWindow(((Window)this.target).isFocusableWindow());
    }

    native void setFocusableWindow(boolean var1);

    public void setTitle(String string) {
        if (string == null) {
            string = new String("");
        }
        this._setTitle(string);
    }

    native void _setTitle(String var1);

    public void setResizable(boolean bl) {
        this._setResizable(bl);
    }

    public native void _setResizable(boolean var1);

    WWindowPeer(Window window) {
        super(window);
    }

    void initialize() {
        super.initialize();
        this.updateInsets(this.insets_);
        Font font = ((Window)this.target).getFont();
        if (font == null) {
            font = defaultFont;
            ((Window)this.target).setFont(font);
            this.setFont(font);
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).addDisplayChangedListener(this);
        this.updateIconImages();
    }

    native void createAwtWindow(WComponentPeer var1);

    void create(WComponentPeer wComponentPeer) {
        this.createAwtWindow(wComponentPeer);
    }

    protected void realShow() {
        super.show();
    }

    public void show() {
        this.updateFocusableWindowState();
        boolean bl = ((Window)this.target).isAlwaysOnTop();
        this.updateGC();
        this.resetTargetGC();
        this.realShow();
        this.updateMinimumSize();
        if (((Window)this.target).isAlwaysOnTopSupported() && bl) {
            this.setAlwaysOnTop(bl);
        }
    }

    native void updateInsets(Insets var1);

    private native Component getContainerElement(Container var1, int var2);

    static native int getSysMinWidth();

    static native int getSysMinHeight();

    static native int getSysIconWidth();

    static native int getSysIconHeight();

    static native int getSysSmIconWidth();

    static native int getSysSmIconHeight();

    native void setIconImagesData(int[] var1, int var2, int var3, int[] var4, int var5, int var6);

    synchronized native void reshapeFrame(int var1, int var2, int var3, int var4);

    public boolean requestWindowFocus() {
        return false;
    }

    public boolean focusAllowedFor() {
        Window window = (Window)this.target;
        if (!(window.isVisible() && window.isEnabled() && window.isFocusable())) {
            return false;
        }
        return !this.isModalBlocked();
    }

    public void updateMinimumSize() {
        Dimension dimension = null;
        if (((Component)this.target).isMinimumSizeSet()) {
            dimension = ((Component)this.target).getMinimumSize();
        }
        if (dimension != null) {
            int n = WWindowPeer.getSysMinWidth();
            int n2 = WWindowPeer.getSysMinHeight();
            int n3 = dimension.width >= n ? dimension.width : n;
            int n4 = dimension.height >= n2 ? dimension.height : n2;
            this.setMinSize(n3, n4);
        } else {
            this.setMinSize(0, 0);
        }
    }

    public void updateIconImages() {
        List<Image> list = ((Window)this.target).getIconImages();
        if (list == null || list.size() == 0) {
            this.setIconImagesData(null, 0, 0, null, 0, 0);
        } else {
            int n = WWindowPeer.getSysIconWidth();
            int n2 = WWindowPeer.getSysIconHeight();
            int n3 = WWindowPeer.getSysSmIconWidth();
            int n4 = WWindowPeer.getSysSmIconHeight();
            DataBufferInt dataBufferInt = SunToolkit.getScaledIconData(list, n, n2);
            DataBufferInt dataBufferInt2 = SunToolkit.getScaledIconData(list, n3, n4);
            if (dataBufferInt != null && dataBufferInt2 != null) {
                this.setIconImagesData(dataBufferInt.getData(), n, n2, dataBufferInt2.getData(), n3, n4);
            } else {
                this.setIconImagesData(null, 0, 0, null, 0, 0);
            }
        }
    }

    native void setMinSize(int var1, int var2);

    public boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModalBlocked(Dialog dialog, boolean bl) {
        Object object = ((Component)this.getTarget()).getTreeLock();
        synchronized (object) {
            WWindowPeer wWindowPeer = (WWindowPeer)dialog.getPeer();
            if (bl) {
                this.modalBlocker = wWindowPeer;
                if (wWindowPeer instanceof WFileDialogPeer) {
                    ((WFileDialogPeer)wWindowPeer).blockWindow(this);
                } else if (wWindowPeer instanceof WPrintDialogPeer) {
                    ((WPrintDialogPeer)wWindowPeer).blockWindow(this);
                } else {
                    this.modalDisable(this.modalBlocker);
                }
            } else {
                this.modalBlocker = null;
                if (wWindowPeer instanceof WFileDialogPeer) {
                    ((WFileDialogPeer)wWindowPeer).unblockWindow(this);
                } else if (wWindowPeer instanceof WPrintDialogPeer) {
                    ((WPrintDialogPeer)wWindowPeer).unblockWindow(this);
                }
                this.modalEnable();
            }
        }
    }

    native void modalDisable(WWindowPeer var1);

    native void modalDisableByHWnd(long var1);

    native void modalEnable();

    public long[] getWindowHandles() {
        WWindowPeer wWindowPeer;
        Object object;
        Window[] windowArray;
        block10: {
            windowArray = null;
            try {
                object = SunToolkit.targetToAppContext(this.target);
                if (object != null) {
                    windowArray = (Window[])getWindowsMethod.invoke(Window.class, object);
                }
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINER)) break block10;
                log.log(Level.FINER, "Exception occured in WWindowPeer.getWindowHandles()", exception);
            }
        }
        if (windowArray == null) {
            return null;
        }
        object = new long[windowArray.length];
        Arrays.fill((long[])object, 0L);
        int n = 0;
        for (Window window : windowArray) {
            if (!(window instanceof EmbeddedFrame)) continue;
            try {
                wWindowPeer = (WEmbeddedFramePeer)peerField.get(window);
                if (wWindowPeer == null) continue;
                object[n++] = wWindowPeer.getHWnd();
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Exception occured in WWindowPeer.getWindowHandles()", exception);
            }
        }
        for (Window window : windowArray) {
            if (window instanceof EmbeddedFrame) continue;
            try {
                wWindowPeer = (WWindowPeer)peerField.get(window);
                if (wWindowPeer == null) continue;
                object[n++] = wWindowPeer.getHWnd();
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Exception occured in WWindowPeer.getWindowHandles()", exception);
            }
        }
        return object;
    }

    void draggedToNewScreen() {
        SunToolkit.executeOnEventHandlerThread((Component)this.target, new Runnable(){

            public void run() {
                WWindowPeer.this.displayChanged();
            }
        });
    }

    void clearLocalGC() {
    }

    public void updateGC() {
        int n = this.getScreenImOn();
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.winGraphicsConfig.getDevice();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Win32GraphicsDevice win32GraphicsDevice2 = n >= graphicsDeviceArray.length ? (Win32GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : (Win32GraphicsDevice)graphicsDeviceArray[n];
        this.winGraphicsConfig = (Win32GraphicsConfig)win32GraphicsDevice2.getDefaultConfiguration();
        if (win32GraphicsDevice != win32GraphicsDevice2) {
            win32GraphicsDevice.removeDisplayChangedListener(this);
            win32GraphicsDevice2.addDisplayChangedListener(this);
        }
    }

    public void displayChanged() {
        this.updateGC();
        super.displayChanged();
    }

    private native int getScreenImOn();

    public void grab() {
        this.nativeGrab();
    }

    public void ungrab() {
        this.nativeUngrab();
    }

    private native void nativeGrab();

    private native void nativeUngrab();

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n, n2, n3, n4);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        int n9 = rectangle.width - insets.left - insets.right;
        int n10 = rectangle.height - insets.top - insets.bottom;
        if (!((Window)this.target).isVisible() || this.isTargetUndecorated()) {
            int n11 = rectangle.x + insets.left;
            int n12 = rectangle.y + insets.top;
            if (n7 > n9) {
                n7 = n9;
            }
            if (n8 > n10) {
                n8 = n10;
            }
            if (n5 < n11) {
                n5 = n11;
            } else if (n5 + n7 > n11 + n9) {
                n5 = n11 + n9 - n7;
            }
            if (n6 < n12) {
                n6 = n12;
            } else if (n6 + n8 > n12 + n10) {
                n6 = n12 + n10 - n8;
            }
        } else {
            int n13 = Math.max(n9, this.sysW);
            int n14 = Math.max(n10, this.sysH);
            if (n7 > n13) {
                n7 = n13;
            }
            if (n8 > n14) {
                n8 = n14;
            }
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        this.sysX = rectangle.x;
        this.sysY = rectangle.y;
        this.sysW = rectangle.width;
        this.sysH = rectangle.height;
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5);
    }

    static {
        WWindowPeer.initIDs();
        peerField = WToolkit.getField(Component.class, "peer");
        getWindowsMethod = WToolkit.getMethod(Window.class, "getWindows", new Class[]{AppContext.class});
        allWindows = new Vector();
    }
}

