/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl;

import com.sun.net.ssl.KeyManagerFactorySpiWrapper;
import com.sun.net.ssl.SSLContextSpiWrapper;
import com.sun.net.ssl.TrustManagerFactorySpiWrapper;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;

final class SSLSecurity {
    private SSLSecurity() {
    }

    private static Provider.Service getService(String string, String string2) {
        ProviderList providerList = Providers.getProviderList();
        for (Provider provider : providerList.providers()) {
            Provider.Service service = provider.getService(string, string2);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] getImpl1(String string, String string2, Provider.Service service) throws NoSuchAlgorithmException {
        Class<?> clazz;
        Object object;
        Provider provider = service.getProvider();
        String string3 = service.getClassName();
        try {
            object = provider.getClass().getClassLoader();
            clazz = object == null ? Class.forName(string3) : ((ClassLoader)object).loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("Class " + string3 + " configured for " + string2 + " not found: " + classNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new NoSuchAlgorithmException("Class " + string3 + " configured for " + string2 + " cannot be accessed: " + securityException.getMessage());
        }
        try {
            Object object2 = null;
            object = Class.forName("javax.net.ssl." + string2 + "Spi");
            if (object != null && SSLSecurity.checkSuperclass(clazz, (Class)object)) {
                if (string2.equals("SSLContext")) {
                    object2 = new SSLContextSpiWrapper(string, provider);
                } else if (string2.equals("TrustManagerFactory")) {
                    object2 = new TrustManagerFactorySpiWrapper(string, provider);
                } else {
                    if (!string2.equals("KeyManagerFactory")) throw new IllegalStateException("Class " + clazz.getName() + " unknown engineType wrapper:" + string2);
                    object2 = new KeyManagerFactorySpiWrapper(string, provider);
                }
            } else {
                Class<?> clazz2 = Class.forName("com.sun.net.ssl." + string2 + "Spi");
                if (clazz2 != null && SSLSecurity.checkSuperclass(clazz, clazz2)) {
                    object2 = service.newInstance(null);
                }
            }
            if (object2 == null) throw new NoSuchAlgorithmException("Couldn't locate correct object or wrapper: " + string2 + " " + string);
            return new Object[]{object2, provider};
        }
        catch (ClassNotFoundException classNotFoundException) {
            IllegalStateException illegalStateException = new IllegalStateException("Engine Class Not Found for " + string2);
            illegalStateException.initCause(classNotFoundException);
            throw illegalStateException;
        }
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service service;
        if (string3 != null) {
            ProviderList providerList = Providers.getProviderList();
            Provider provider = providerList.getProvider(string3);
            if (provider == null) {
                throw new NoSuchProviderException("No such provider: " + string3);
            }
            service = provider.getService(string2, string);
        } else {
            service = SSLSecurity.getService(string2, string);
        }
        if (service == null) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not available");
        }
        return SSLSecurity.getImpl1(string, string2, service);
    }

    static Object[] getImpl(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = provider.getService(string2, string);
        if (service == null) {
            throw new NoSuchAlgorithmException("No such algorithm: " + string);
        }
        return SSLSecurity.getImpl1(string, string2, service);
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return false;
        }
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] truncateArray(Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }
}

