/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.util.Trace;
import com.sun.javaws.BrowserSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;

    private BasicServiceImpl(URL uRL, boolean bl) {
        this._codebase = uRL;
        this._isWebBrowserSupported = bl;
        if (Config.isJavaVersionAtLeast16()) {
            try {
                DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL uRL, boolean bl) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(uRL, bl);
        }
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    public boolean showDocument(final URL uRL) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadEngine.isJnlpURL((URL)uRL)) {
                    try {
                        String[] stringArray = new String[]{Config.getJavawsCommand(), "-Xnosplash", uRL.toString()};
                        Runtime.getRuntime().exec(stringArray);
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        });
        if (bl != null && bl.booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL2 = uRL;
                try {
                    uRL2 = new URL(BasicServiceImpl.this._codebase, uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return new Boolean(BrowserSupport.showDocument(uRL2));
            }
        });
        return bl == null ? false : bl;
    }

    public boolean isWebBrowserSupported() {
        return this._isWebBrowserSupported;
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL uRL) {
            BasicServiceImpl.this.showDocument(uRL);
        }
    }
}

