//
//  DKBezier.h
//  DrawKit
//
//  Created by Graham on 8/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface DKBezier : NSObject
{
@private
	CGFloat			x1, x2, x3, x4;
	CGFloat			y1, y2, y3, y4;
}

+ (CGFloat)			defaultError;


- (id)				initWithStartingPoint:(NSPoint) p0 controlPoint1:(NSPoint) cp1 controlPoint2:(NSPoint) cp2 endingPoint:(NSPoint) p1;
- (id)				initWithPoints:(NSPoint[4]) pts;

- (NSPoint)			p0;
- (NSPoint)			cp1;
- (NSPoint)			cp2;
- (NSPoint)			p1;

- (NSPoint)			pointAtT:(CGFloat) t;
- (NSPoint)			normalAtT:(CGFloat) t;
- (NSPoint)			derivativeAtT:(CGFloat) t;
- (NSPoint)			secondDerivativeAtT:(CGFloat) t;
- (NSPoint)			midPoint;

- (CGFloat)			slopeAtT:(CGFloat) t;

- (NSRect)			bounds;
- (BOOL)			isLine;

- (CGFloat)			length;
- (CGFloat)			lengthWithMaximumError:(CGFloat) maxError;

- (CGFloat)			tAtLength:(CGFloat) length;

- (void)			splitAtT:(CGFloat) t firstHalf:(DKBezier**) bz1 secondHalf:(DKBezier**) bz2;
- (DKBezier*)		bezierFromT:(CGFloat) t0 toT:(CGFloat) t1;
- (void)			bisectToFirstHalf:(DKBezier**) bez1 secondHalf:(DKBezier**) bez2;

- (DKBezier*)		bezierByReversingBezier;

- (void)			appendToBezierPath:(NSBezierPath*) path;
- (NSBezierPath*)	bezierPath;

- (NSArray*)		flattenToPointsWithFlatness:(CGFloat) flatness;

@end

/*

This class describes a single cubic bezier segment, and provides methods for the mathematical manipulation of it, such as
 splitting, finding points, coefficients, and so on. The category below can be used to let it interoperate with NSBezierPath.

A DKBezier is described by four points: p0 is the starting point, cp1 and cp2 the control points, and p1 the ending point. You can init
 a DKBezier from four distinct points, or pass a point array. In the latter case, the point array has the same order as the result
 returned by NSBezierPath



*/


@interface NSBezierPath (DKBezierAdditions)

- (void)		appendDKBezier:(DKBezier*) bez;

@end

