///**********************************************************************************************************************************
///  DKCIFilterRastGroup.h
///  DrawKit ©2005-2008 Apptree.net
///
///  Created by graham on 16/03/2007.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
///
///**********************************************************************************************************************************

#import "DKRastGroup.h"


@interface DKCIFilterRastGroup : DKRastGroup <NSCoding, NSCopying>
{
@private
	CGFloat				mPaddingScale;
	BOOL				mIsDrawing;
	BOOL				mCacheInvalid;
	NSMutableArray*		mFilterStack;
	NSString*			mUniqueKey;
	id					mPriorValue;
}

@property (nonatomic, retain) id	priorValue;


+ (DKCIFilterRastGroup*)	effectGroupWithFilterNamed:(NSString*) filtername arguments:(NSDictionary*) args;
+ (DKCIFilterRastGroup*)	effectGroupWithCIFilter:(CIFilter*) filter;

+ (DKCIFilterRastGroup*)	gaussianBlurEffectWithStdDeviation:(CGFloat) dev;

- (void)					setPaddingMultiplier:(CGFloat) pm;
- (CGFloat)					paddingMultiplier;

- (CIImage*)				resultWithObject:(id<DKRenderable>) obj;

// filter stacking methods:

- (void)					addFilter:(CIFilter*) filter;
- (void)					removeFilter:(CIFilter*) filter;
- (CIFilter*)				addFilterWithName:(NSString*) filterName;
- (void)					addFiltersWithNames:(NSArray*) names arguments:(NSArray*) args;
- (CIFilter*)				firstFilter;
- (void)					moveFilter:(CIFilter*) filter toIndex:(NSUInteger) indx;

// KVO-compliant property 'filters':

- (NSArray*)				filters;
- (void)					setFilters:(NSArray*) filters;
- (NSUInteger)				countOfFilters;

- (CIFilter*)				objectInFiltersAtIndex:(NSUInteger) indx;
- (NSArray*)				filtersAtIndexes:(NSIndexSet*) indexes;

- (void)					insertObject:(CIFilter*) filter inFiltersAtIndex:(NSUInteger) indx;
- (void)					removeObjectFromFiltersAtIndex:(NSUInteger) indx;

@end

// deprecated methods pertain to single-filter operations. Deprecated in favour of filterstacks (which can have just one filter)


@interface DKCIFilterRastGroup (Deprecated)

+ (DKCIFilterRastGroup*)	effectGroupWithFilter:(NSString*) filter;

- (void)					setFilter:(NSString*) filter;
- (NSString*)				filter;

- (void)					setArguments:(NSDictionary*) dict;
- (NSDictionary*)			arguments;

- (CIFilter*)				CIFilter;
- (void)					setCIFilter:(CIFilter*) filter;

@end

// to permit finer control over certain kinds of filtering operation, we define the following DK attribute keys
// these are ignored by Core Image, but are read by this class for some filters

extern NSString*		kDKGaussianBlurStandardDeviation;

extern NSString* const kDKCIFilterRastGroupCachedImageKey;
extern NSString* const kDKCIFilterRastGroupSourceRectKey;
extern NSString* const kDKCIFilterRastGroupDestRectKey;
extern NSString* const kDKCIFilterRastGroupImageExtentKey;


#define CIIMAGE_DEFAULT_PADDING_MULTIPLIER		1.5

/*

This class implements a special rendergroup that captures the output of its contained renderers in an image, then
allows that image to be manipulated or processed (e.g. by core image) before rendering it back to the drawing. This
allows us to leverage all sorts of imaging code to extend the range of available styles and effects.
 
 This class can support any number of chained CIFilters (a filter stack) which allows the full range of effects
 provided by Core Image filters.

*/
