/*
 *  DKDrawKitMacros.h
///  DrawKit ©2005-2008 Apptree.net
 *
 *  Created by graham on 25/02/2008.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
 *
 */

//#import <Cocoa/Cocoa.h>

// pinning a value between a lower and upper limit

#define LIMIT( value, min, max )		(((value) < (min))? (min) : (((value) > (max))? (max) : (value)))

// converting from radians to degrees

#define	DEGREES_TO_RADIANS( d )			((d) * 0.0174532925199432958)
#define RADIANS_TO_DEGREES( r )			((r) * 57.29577951308232)

// converting common measurement units to/from points

#define MILLIMETRES_TO_POINTS( mm )		((mm) * 2.83465)
#define POINTS_TO_MILLIMETRES( pts )	((pts) * 0.352777)
#define CENTIMETRES_TO_POINTS( cm )		((cm) * 28.3465)
#define POINTS_TO_CENTIMETRES( pts )	((pts) * 0.0352777)
#define INCHES_TO_POINTS( in )			((in) * 72.0 )
#define POINTS_TO_INCHES( pts )			((pts) * 0.0138888888)

// some useful angular constants

#define FIFTEEN_DEGREES					(M_PI / 12.0)
#define NINETY_DEGREES					(M_PI * 0.5)
#define SIXTY_DEGREES					(M_PI / 3.0 )
#define FORTYFIVE_DEGREES				(M_PI * 0.25)
#define THIRTY_DEGREES					(M_PI / 6.0 )
#define HALF_PI							(M_PI * 0.5)

// exception safe save/restore of the current graphics context

#define	SAVE_GRAPHICS_CONTEXT			@try { [NSGraphicsContext saveGraphicsState];
#define RESTORE_GRAPHICS_CONTEXT		} @finally { [NSGraphicsContext restoreGraphicsState]; }


// 64-bit float macros

#ifdef __LP64__
	#define _CGFloatFabs( n )	fabs( n )
	#define _CGFloatTrunc( n )	trunc( n )
	#define _CGFloatLround( n )	roundtol( n )
	#define _CGFloatFloor( n )	floor( n )
	#define _CGFloatCeil( n )	ceil( n )
	#define _CGFloatExp( n )	exp( n )
	#define _CGFloatSqrt( n )	sqrt( n )
	#define _CGFloatLog( n )	log( n )
#else
	#define _CGFloatFabs( n )	fabsf( n )
	#define _CGFloatTrunc( n )	truncf( n )
	#define _CGFloatLround( n )	roundtol((double) n )
	#define _CGFloatFloor( n )	floorf( n )
	#define _CGFloatCeil( n )	ceilf( n )
	#define _CGFloatExp( n )	expf( n )
	#define _CGFloatSqrt( n )	sqrtf( n )
	#define _CGFloatLog( n )	logf( n )
#endif


// generic iteration allows fast enumerators where available
// note that DK now requires Obj-C 2.0, so these macros are no longer required, and are deprecated.

#define DK_USE_FAST_ENUMERATION			1

#if DK_USE_FAST_ENUMERATION

#define ITERATE( variable, collection )		for( id (variable) in ( collection ))
#define ITERATE_KEYS( keyVar, dictionary )	for( id (keyVar) in ( dictionary ))

#else

#define ITERATE( variable, collection )		NSEnumerator* dk_iter = [(collection) objectEnumerator];\
											id (variable);\
											while((( variable ) = [dk_iter nextObject]))

#define ITERATE_KEYS( keyVar, dictionary )	NSEnumerator* dk_iter = [(dictionary) keyEnumerator];\
											id (keyVar);\
											while((( keyVar ) = [dk_iter nextObject]))

#endif



