///**********************************************************************************************************************************
///  DKDrawableContainerProtocol.h
///  DrawKit ©2005-2008 Apptree.net
///
///  Created by graham on 01/03/2009
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
///
///**********************************************************************************************************************************


#import <Cocoa/Cocoa.h>

@class DKDrawing, DKLayer, DKDrawableObject, DKMetadataItem;


@protocol DKDrawableContainer <NSObject>

// relationships:

- (DKDrawing*)				drawing;
- (DKLayer*)				layer;

// imaging:

- (NSAffineTransform*)		renderingTransform;

@optional

// object containment:
// containment is optional, in that some kinds of container might not actually store a collection of objects, but instead wrap a single
// object for a specific purpose. If the container is truly a container for multiple objects however, it should adopt all of these methods.

- (void)					setObjects:(NSArray*) objs;																// KVC/KVO compliant
- (NSArray*)				objects;																				// KVC/KVO compliant
- (NSUInteger)				countOfObjects;																			// KVC/KVO compliant
- (DKDrawableObject*)		objectInObjectsAtIndex:(NSUInteger) indx;												// KVC/KVO compliant
- (NSArray*)				objectsAtIndexes:(NSIndexSet*) set;														// KVC/KVO compliant

- (void)					insertObject:(DKDrawableObject*) obj inObjectsAtIndex:(NSUInteger) indx;				// KVC/KVO compliant
- (void)					removeObjectFromObjectsAtIndex:(NSUInteger) indx;										// KVC/KVO compliant
- (void)					replaceObjectInObjectsAtIndex:(NSUInteger) indx withObject:(DKDrawableObject*) obj;		// KVC/KVO compliant
- (void)					insertObjects:(NSArray*) objs atIndexes:(NSIndexSet*) set;								// KVC/KVO compliant
- (void)					removeObjectsAtIndexes:(NSIndexSet*) set;												// KVC/KVO compliant

- (NSUInteger)				indexOfObject:(DKDrawableObject*) obj;
- (BOOL)					isSelectedObject:(DKDrawableObject*) obj;

// metadata:

- (DKMetadataItem*)			metadataItemForKey:(NSString*) key;
- (id)						metadataObjectForKey:(NSString*) key;

// ghosting:

- (BOOL)					isGhosted;

@end





/*

Objects that claim ownership of a DKDrawableObject must formally implement this protocol.
 
This includes DKObjectOwnerLayer, DKShapeGroup


*/


