//
//  DKDrawing+GridsAndGuides.h
//  GCDrawKit
//
//  Created by Graham Cox on 7/06/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import "DKDrawing.h"
#import "DKIsometricGridLayer.h"



@interface DKDrawing (GridsAndGuides)

+ (void)					setSnapToGridOnGridVisible:(BOOL) snap;
+ (BOOL)					snapToGridOnGridVisible;


- (void)					setGridType:(DKGridType) gridType;
- (DKGridType)				gridType;

// interaction with grid and guides

- (void)					setSnapsToGrid:(BOOL) snaps;
- (BOOL)					snapsToGrid;
- (void)					setSnapsToGuides:(BOOL) snaps;
- (BOOL)					snapsToGuides;

- (NSPoint)					snapToGrid:(NSPoint) p withControlFlag:(BOOL) snapControl;
- (NSPoint)					snapToGrid:(NSPoint) p ignoringUserSetting:(BOOL) ignore;
- (NSPoint)					snapToGuides:(NSPoint) p;
- (NSRect)					snapRectToGuides:(NSRect) r includingCentres:(BOOL) cent;
- (NSSize)					snapPointsToGuide:(NSArray*) points;

- (NSSize)					nudgeOffset;
- (NSSize)					nudgeOffsetWithOption:(DKNudgeDistanceOption) opt;

- (DKGridLayer*)			gridLayer;
- (DKGuideLayer*)			guideLayer;
- (CGFloat)					convertLength:(CGFloat) len;
- (NSPoint)					convertPoint:(NSPoint) pt;
- (NSPoint)					convertPointFromDrawingToBase:(NSPoint) pt;
- (CGFloat)					convertLengthFromDrawingToBase:(CGFloat) len;

- (NSString*)				formattedConvertedLength:(CGFloat) len;
- (NSArray*)				formattedConvertedPoint:(NSPoint) pt;

@end


extern NSString* const kDKSnapToGridOnGridVisibleDefaultsKey;