//
//  DKDrawingView+TextEditing.h
//  GCDrawKit
//
//  Created by Graham Cox on 3/07/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import "DKDrawingView.h"

@interface DKDrawingView (TextEditing)


// editing text directly in the drawing:

- (NSTextView*)			editText:(NSAttributedString*) text inRect:(NSRect) rect delegate:(id) del;
- (NSTextView*)			editText:(NSAttributedString*) text inRect:(NSRect) rect delegate:(id) del drawsBackground:(BOOL) drawBkGnd;
- (void)				endTextEditing;
- (NSTextStorage*)		editedText;
- (NSTextView*)			textEditingView;
- (void)				editorFrameChangedNotification:(NSNotification*) note;
- (BOOL)				isTextBeingEdited;


@end




@interface DKTextEditingViewController : NSViewController
{
	IBOutlet NSTextView*	mTextView;
	IBOutlet NSScrollView*	mScrollView;
	IBOutlet NSButton*		mCancelButton;
	IBOutlet NSButton*		mAcceptButton;
}

- (NSTextView*)		textview;
- (NSScrollView*)	scrollview;

@end