//
//  DKEdge.h
//  DrawKit
//
//  Created by Graham on 8/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface DKEdge : NSObject
{
@private
	CGFloat			x1, x2;
	CGFloat			y1, y2;
}

- (id)				initWithPoint1:(NSPoint) pt1 point2:(NSPoint) pt2;
- (id)				initWithPoints:(NSPoint[2]) points;
- (id)				initWithPoint:(NSPoint)p angle:(CGFloat) angle length:(CGFloat) length;

- (NSPoint)			p0;
- (NSPoint)			p1;
- (CGFloat)			dx;
- (CGFloat)			dy;

- (CGFloat)			length;
- (NSPoint)			interpolateAtT:(CGFloat) t;
- (NSPoint)			midPoint;
- (NSRect)			bounds;

- (BOOL)			isEqualToEdge:(DKEdge*) edge;
- (BOOL)			coincidentWithEdge:(DKEdge*) edge;
- (BOOL)			intersectsEdge:(DKEdge*) edge atPoint:(NSPoint*) result t1:(CGFloat*) t1 t2:(CGFloat*) t2;

- (NSInteger)		sideFromEdge:(NSPoint) p;
- (NSPoint)			nearestPointFromPoint:(NSPoint) p;
- (CGFloat)			distanceFromEdge:(NSPoint) p;

- (CGFloat)			angle;
- (CGFloat)			angleFromEdge:(DKEdge*) edge;

- (DKEdge*)			edgeByReversingEdge;

- (void)			appendToBezierPath:(NSBezierPath*) path;
- (NSBezierPath*)	bezierPath;

@end



/*

DKEdge represents a single line segment between two points.


*/


@interface NSBezierPath (DKEdgeAdditions)

- (void)			appendEdge:(DKEdge*) edge;


@end


