//
//  DKGestureRecogniser.h
//  GCDrawKit
//
//  Created by Graham Cox on 29/06/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface DKGestureRecogniser : NSObject
{
@private
	id				mDelegateRef;			// the delegate, called when the gesture is recognised
	NSView*			mViewRef;				// the view associated wit hthe receiver. Must be set if you wish to extract touches from the event.
	SEL				mSelector;				// optional selector value that the delegate can set to refine its response to a gesture
	NSDictionary*	mUserInfo;				// optional user info that can be set to associate any data with the gesture
	NSUInteger		mIndex;					// internal index value used to track the recogniser
	NSPoint			mLoc;					// location in window of last event seen
}


@property (assign, nonatomic) id			delegate;
@property (assign, nonatomic) NSView*		view;
@property (assign, nonatomic) SEL			selector;
@property (retain, nonatomic) NSDictionary* userInfo;

- (id)		initWithView:(NSView*) view;	// designated initializer
- (NSPoint)	locationInWindow;

- (void)	touchesBeganWithEvent:(NSEvent*) event;
- (void)	touchesEndedWithEvent:(NSEvent*) event;
- (void)	touchesMovedWithEvent:(NSEvent*) event;
- (void)	touchesCancelledWithEvent:(NSEvent*) event;

- (void)	reset;
- (void)	notifyDelegate;

@end



@interface NSObject (DKGestureRecognizerDelegate)

- (void)	gestureWasRecognised:(DKGestureRecogniser*) gr;

@end



/*

This class encapsulates the details of detecting non-standard gestures. DKGestureRecogniser is an abstract class which receives the raw touch events. When a gesture is
 recognised the delegate is informed.
 
 At this time this is not as sophisticated as the iOS equivalent, and may well be superceded by something in the OS eventually anyway.

DKViewController owns a list of these and hands on the events to all recognizers at once. In addition, all recognisers are kept in a private list
 so that as soon as a gesture is recognised, the state of the others can be reset so that only one recogniser can be triggered. A single list is
 fine since the user is only able to interact with one view at a time, and multiple recognisers for the same gesture can't be active simultaneously.




*/