//
//  DKOGradientFill.h
//  GCDrawKit
//
//  Created by graham on 22/11/2008.
//  Copyright 2008 Apptree.net. All rights reserved.
//

#import "DKFill.h"

#if !defined(DKGradientType)

typedef enum
{
	kDKGradientTypeLinear,
	kDKGradientTypeRadial
}
DKGradientType;

#endif


@interface DKGradientFill : DKFill <NSCoding, NSCopying>
{
@private
	NSGradient*			mGradient;				// gradient object performs the drawing and sets colours and stops
	DKGradientType		mGradientType;			// type of fill
	CGFloat				mAngle;					// linear gradient angle in radians
	NSPoint				mStartCentre;
	NSPoint				mEndCentre;
	CGFloat				mStartRadius;
	CGFloat				mEndRadius;
	BOOL				mLocationsRelativeToObject;	// if YES, start and end points and radii are stored as 0..1 values and scaled to the object size
	BOOL				mAngleRelativeToObject;
	NSAffineTransform*	mTransform;
	NSImage*			mCachedImage;
}

+ (DKGradientFill*)		defaultGradientFill;
+ (DKGradientFill*)		gradientFillWithGradient:(NSGradient*) grad type:(DKGradientType) type;

+ (void)				setPDFTransparencyWorkaround:(BOOL) ptw;
+ (BOOL)				pdfTransparencyWorkaround;

- (void)				setGradient:(NSGradient*) aGradient;
- (NSGradient*)			gradient;

- (void)				setGradientType:(DKGradientType) aType;
- (DKGradientType)		gradientType;

- (void)				setGradientAngle:(CGFloat) angle;
- (CGFloat)				gradientAngle;
- (void)				setGradientAngleInDegrees:(CGFloat) degrees;
- (CGFloat)				gradientAngleInDegrees;

- (void)				setStartingLocation:(NSPoint) sp;
- (void)				setStartingRadius:(CGFloat) radius;
- (void)				setEndingLocation:(NSPoint) ep;
- (void)				setEndingRadius:(CGFloat) radius;
- (NSPoint)				startingLocation;
- (NSPoint)				endingLocation;
- (CGFloat)				startingRadius;
- (CGFloat)				endingRadius;

- (void)				setAngleIsRelative:(BOOL) rel;
- (BOOL)				angleIsRelative;

- (void)				setGradientTransform:(NSAffineTransform*) tfm;
- (NSAffineTransform*)	gradientTransform;

- (void)				setParametersAreRelativeToObject:(BOOL) rel;
- (BOOL)				parametersAreRelativeToObject;

- (NSString*)			displayName;

- (void)				drawInRect:(NSRect) rect angle:(CGFloat) angle;

- (NSUInteger)			numberOfColours;
- (NSColor*)			colourAtStopIndex:(NSUInteger) indx;
- (BOOL)				hasAnyTransparentColours;

- (NSImage*)			gradientImageOfSize:(NSSize) size angle:(CGFloat) angle;

@end


@interface DKGradientFill (Deprecated)

- (void)				setRadialParametersAreRelative:(BOOL) rel;
- (BOOL)				radialParametersAreRelative;

@end


extern NSString* const	kDKGradientPDFTransparencyWorkaroundDefaultsKey;






/*
 
 Rasterizer for drawing a gradient fill. This is 10.5 only as it makes use of NSGradient. It's intended to simplify the specification of gradients independently
 of the gradient parameter for DKFill, which will still work but whose gradient parameter may be left unused and unexposed in a UI.
 
 
 */
