//
//  DKGradientStroke.h
//  DrawKit
//
//  Created by Graham on 21/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import "DKStroke.h"
#import "DKGradientFill.h"




@interface DKGradientStroke : DKStroke <NSCoding, NSCopying>
{
@private
	NSGradient*			mGradient;					// gradient object performs the drawing and sets colours and stops
	DKGradientType		mGradientType;				// type of gradient
	CGFloat				mAngle;						// linear gradient angle in radians
	NSPoint				mStartCentre;
	NSPoint				mEndCentre;
	CGFloat				mStartRadius;
	CGFloat				mEndRadius;
	BOOL				mLocationsRelativeToObject;	// if YES, start and end points and radii are stored as 0..1 values and scaled to the object size
	BOOL				mAngleRelativeToObject;
}


+ (DKGradientStroke*)	defaultGradientStroke;
+ (DKGradientStroke*)	gradientStrokeWithGradient:(NSGradient*) grad type:(DKGradientType) type;

- (void)				setGradient:(NSGradient*) aGradient;
- (NSGradient*)			gradient;

- (void)				setGradientType:(DKGradientType) aType;
- (DKGradientType)		gradientType;

- (void)				setGradientAngle:(CGFloat) angle;
- (CGFloat)				gradientAngle;
- (void)				setGradientAngleInDegrees:(CGFloat) degrees;
- (CGFloat)				gradientAngleInDegrees;

- (void)				setStartingLocation:(NSPoint) sp;
- (void)				setStartingRadius:(CGFloat) radius;
- (void)				setEndingLocation:(NSPoint) ep;
- (void)				setEndingRadius:(CGFloat) radius;
- (NSPoint)				startingLocation;
- (NSPoint)				endingLocation;
- (CGFloat)				startingRadius;
- (CGFloat)				endingRadius;

- (void)				setRadialParametersAreRelative:(BOOL) rel;
- (BOOL)				radialParametersAreRelative;
- (void)				setAngleIsRelative:(BOOL) rel;
- (BOOL)				angleIsRelative;

- (void)				drawInRect:(NSRect) rect angle:(CGFloat) objAngle;
- (NSString*)			displayName;

- (NSUInteger)			numberOfColours;
- (NSColor*)			colourAtStopIndex:(NSUInteger) indx;

@end
