///**********************************************************************************************************************************
///  DKImageAdornment.h
///  DrawKit ©2005-2008 Apptree.net
///
///  Created by graham on 15/05/2007.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
///
///**********************************************************************************************************************************

#import "DKRasterizer.h"


@class DKDrawableObject, DKDrawing;

// fitting options:

typedef enum
{
	kDKScaleToFitBounds					= 0,			// scale setting ignored - image will fill bounds
	kDKScaleToFitPreservingAspectRatio	= 1,			// scale setting ignored - image will fit bounds with original aspect ratio preserved
	kDKClipToBounds						= 2				// scales according to setting, but clipped to object's path if size exceeds it
}
DKImageFittingOption;




@interface DKImageAdornment : DKRasterizer <NSCoding, NSCopying>
{
@private
	//NSString*				mImageKey;
	NSImage*				m_image;
	NSData*					mImageData;
	CGFloat					m_scale;
	CGFloat					m_opacity;
	CGFloat					m_angle;
	NSPoint					m_origin;
	NSCompositingOperation	m_op;
	DKImageFittingOption	m_fittingOption;
	NSString*				m_imageIdentifier;
}

+ (DKImageAdornment*)	imageAdornmentWithImageFromFile:(NSString*) path;
+ (DKImageAdornment*)	imageAdornmentWithData:(NSData*) imageData;

- (NSData*)				imageData;
- (void)				setImageData:(NSData*) imageData;
- (NSImage*)			image;

- (void)				setImageIdentifier:(NSString*) imageID;
- (NSString*)			imageIdentifier;

- (void)				setScale:(CGFloat) scale;
- (CGFloat)				scale;

- (void)				setOpacity:(CGFloat) opacity;
- (CGFloat)				opacity;

- (void)				setOrigin:(NSPoint) origin;
- (NSPoint)				origin;

- (void)				setAngle:(CGFloat) angle;
- (CGFloat)				angle;
- (void)				setAngleInDegrees:(CGFloat) degrees;
- (CGFloat)				angleInDegrees;

- (void)				setOperation:(NSCompositingOperation) op;
- (NSCompositingOperation) operation;

- (void)				setFittingOption:(DKImageFittingOption) fopt;
- (DKImageFittingOption) fittingOption;

- (NSAffineTransform*)	imageTransformForObject:(id<DKRenderable>) renderableObject;

@end

#define DRAWKIT_IMAGE_ADORMENT_DEPRECATED		1

#if DRAWKIT_IMAGE_ADORMENT_DEPRECATED

@interface DKImageAdornment (Deprecated)

+ (DKImageAdornment*)	imageAdornmentWithImage:(NSImage*) image;

- (void)				setImage:(NSImage*) image;

- (void)				setImageWithKey:(NSString*) key forDrawing:(DKDrawing*) drawing;
- (void)				setImageKey:(NSString*) key;
- (NSString*)			imageKey;


@end

#endif

/*

This class allows any image to be part of the rendering tree. 

*/
