//
//  DKImageDataManager.h
//  GCDrawKit
//
//  Created by graham on 27/11/2008.
//  Copyright 2008 Apptree.net. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface DKImageDataManager : NSObject
{
@private
	NSMutableDictionary*	mRepository;
	//NSMutableDictionary*	mHashList;
}

+ (DKImageDataManager*)		sharedImageDataManager;
+ (NSData*)					registerSharableData:(NSData*) data returningKey:(id<NSCopying>*) key;
+ (NSData*)					registerSharableData:(NSData*) data withPrecomputedKey:(id<NSCopying>) key;

+ (NSImage*)				updatedVersionRequiredImage;

- (NSData*)					registerData:(NSData*) data returningKey:(id<NSCopying>*) key;
- (void)					removeData:(NSData*) data;

- (NSData*)					dataForKey:(id<NSCopying>) key;

- (NSArray*)				allKeys;
- (NSArray*)				allImageData;

- (NSDictionary*)			fileWrappersWithKeys:(NSArray*) keys;
- (void)					addImageDataFromFileWrappers:(NSDictionary*) fwDict;

@end

#define DEPRECATED_IMAGE_DATA_MANAGER		0


#if DEPRECATED_IMAGE_DATA_MANAGER

@interface DKImageDataManager (Deprecated)

- (NSImage*)		makeImageWithData:(NSData*) imageData key:(NSString**) key;
- (NSImage*)		makeImageWithPasteboard:(NSPasteboard*) pb key:(NSString**) key;
- (NSImage*)		makeImageWithContentsOfURL:(NSURL*) url key:(NSString**) key;
- (NSImage*)		makeImageForKey:(NSString*) key;

- (void)			setKey:(NSString*) key isInUse:(BOOL) inUse;
- (BOOL)			keyIsInUse:(NSString*) key;
- (void)			removeUnusedData;
- (NSString*)		generateKey;
- (void)			removeKey:(NSString*) key;

- (NSData*)			imageDataForKey:(NSString*) key;
- (BOOL)			hasImageDataForKey:(NSString*) key;

@end

#endif

extern NSString*	kDKImageDataManagerPasteboardType;


@interface NSData	(Checksum)

- (NSUInteger)		checksum;
- (NSString*)		checksumString;

@end


/*

 The purpose of this class is to allow images to be archived much more efficiently, by archiving the original data that the image was created from rather than any bitmaps or
 other uncompressed forms, and to avoid storing multiple copies of the same image. Each drawing will have an instance of this class and any image using objects such as DKImageShape
 can make use of it.
 
 This only comes into play when archiving, dearchiving or creating images - each object still maintains an NSImage derived from the data stored here.
 
 When images are cut/pasted within the framework, the image key can be used to effect that operation without having to move the actual image data.
 
 ###############
 
 Later version (updated for Artboard 1.1.2 and later)
 
 This class is much simplified. Its purpose is still the same - to consolidate the reuse of images in a document for efficient archiving. But the way it does it is much simpler.
 
 Instead of making images, its job is simply to detect common chunks of data (as NSData objects) and avoid the same actual data being held by different NSData objects. There is no need
 for the image manager itself to be archived (as has been the case for a while now anyway), but merely to detect data it already knows about and return the same object to as many clients
 as want it. Then the standard archiving mechanism will avoid archiving the same object more than once.
 
 Therefore the actual making of images has been deprecated - it doesn't really matter that images end up as different objects made from the same data, as these are transitory anyway.
 The archive never contains image objects, but instead image data. In addition, we can now avoid the need to have an image manager per document, and can instead have a global (singleton)
 image manager. That it will contain data objects that are not currently in use will not matter significantly, especially where these are file mapped. The result is much simpler client
 code, more effective data sharing, and much cleaner archiving.
 
 Clients of this class are DKImageShape and any rasterizers that store and render images.

*/


