///**********************************************************************************************************************************
///  DKImageShape+Vectorization.h
///  DrawKit ©2005-2008 Apptree.net
///
///  Created by graham on 25/06/2007.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
///
///**********************************************************************************************************************************

#import "DKImageShape.h"
#import "NSImage+Tracing.h"

@class DKShapeGroup;


typedef enum
{
	kDKVectorizeColour		= 0,
	kDKVectorizeGrayscale	= 1
}
DKVectorizingMethod;

// this category implements very high-level vectorizing operations on an image shape. At its simplest,
// it vectorizes the image using the default settings and replaces the image object by a group containing the
// shapes resulting. For the user, this looks like a vectorization operation was applied "in place".

// Apps are free to implement this in a more controlled way if they wish, for example by using a dialog
// to set up the various parameters.

// Be sure to also check out NSImage+Tracing because that's where the real work is done.


@interface DKImageShape (Vectorization)

+ (void)			setPreferredVectorizingMethod:(DKVectorizingMethod) method;
+ (void)			setPreferredVectorizingPrecision:(NSInteger) colourPrecision;
+ (void)			setPreferredQuantizationMethod:(DKColourQuantizationMethod) qm;

+ (DKVectorizingMethod)			preferredVectorizingMethod;
+ (NSInteger)					preferredVectorizingPrecision;
+ (DKColourQuantizationMethod)	preferredQuantizationMethod;

+ (void)			setTracingParameters:(NSDictionary*) traceInfo;
+ (NSDictionary*)	tracingParameters;

- (DKShapeGroup*)	makeGroupByVectorizing;
- (DKShapeGroup*)	makeGroupByGrayscaleVectorizingWithPrecision:(NSInteger) grayPrecision;
- (DKShapeGroup*)	makeGroupByColourVectorizingWithPrecision:(NSInteger) colourPrecision;

- (NSArray*)		makeObjectsByVectorizing;
- (NSArray*)		makeObjectsByGrayscaleVectorizingWithPrecision:(NSInteger) grayPrecision;
- (NSArray*)		makeObjectsByColourVectorizingWithPrecision:(NSInteger) colourPrecision;

- (IBAction)		vectorize:(id) sender;

@end


// additional dict keys that can be set in the trace params:

extern NSString*	kDKIncludeStrokeStyle;		// BOOL
extern NSString*	kDKStrokeStyleWidth;		// float
extern NSString*	kDKStrokeStyleColour;		// NSColor

// user defaults keys

extern NSString* const kDKImageVectorizingMethodDefaultsKey;
extern NSString* const kDKImageVectorizingGrayLevelsDefaultsKey;
extern NSString* const kDKImageVectorizingColourPrecisionDefaultsKey;
extern NSString* const kDKImageVectorizingColourQuantizationMethodKey;


