///**********************************************************************************************************************************
///  DKImageShape.m
///  DrawKit �2005-2008 Apptree.net
///
///  Created by graham on 23/08/2006.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
///
///**********************************************************************************************************************************

#import "DKDrawableShape.h"

// option constants for crop or scale image (deprecated)

typedef enum
{
	kDKImageScaleToPath				= 0,
	kDKImageCropToPath				= 1
}
DKImageCroppingOptions;

// presentation mode toggles between 'normal' and image positioning mode where user can simply drag directly
// to position an image and operate an embedded scaling control

typedef enum
{
	kDKImageNormalPresentationMode		= 0,
	kDKImagePositioningPresentationMode = 1
}
DKImagePresentationMode;


@class GCDataHash;



// the class

@interface DKImageShape : DKDrawableShape <NSCoding, NSCopying>
{
@private
	NSData*					mOriginalImageData;		// original image data (shared with image manager)
	GCDataHash*				mImageDataHash;			// original data hash value
	NSImage*				m_image;				// the image the shape displays
	CGFloat					m_opacity;				// its opacity
	CGFloat					m_imageScale;			// its scale, 1.0 = 100%
	NSPoint					m_imageOffset;			// the offset of the image within the bounds
	BOOL					m_drawnOnTop;			// YES if image drawn after style, NO for before
	NSCompositingOperation	m_op;					// the Quartz compositing mode to apply
	DKImageCroppingOptions	mImageCropping;			// whether the image is scaled or cropped to the bounds
	NSInteger				mImageOffsetPartcode;	// the partcode of the image offset hotspot
	DKImagePresentationMode	mPresentationMode;		// what presentation mode the object is in
	NSUInteger				mIndex;					// used to track current presentation object
	NSPoint					mOriginalOrigin;		// for positioning in pos mode
	NSSize					mOriginalSize;			// for sizing in pos mode
	BOOL					mDraggingScaleControl;	// YES while dragging the direct scaling control
	NSPoint					mImagePosMouseAnchor;	// location of mouse relative to top, left of frame
	NSShadow*				mImageShadow;			// shadow for image, if any
}

@property (nonatomic, retain) NSShadow*		imageShadow;
@property (nonatomic, retain) GCDataHash*	imageHash;

+ (DKStyle*)				imageShapeDefaultStyle;
+ (DKStyle*)				imagePositioningModeBorderStyle;
+ (id)						imageEditorController;

+ (void)					setPresentingImageObject:(DKImageShape*) imageShape;
+ (DKImageShape*)			presentingImageObject;

- (id)						initWithImage:(NSImage*) anImage;
- (id)						initWithImageData:(NSData*) imageData;
- (id)						initWithContentsOfFile:(NSString*) filepath;

- (void)					setImage:(NSImage*) anImage;
- (NSImage*)				image;
- (NSImage*)				resampledAndCroppedImage;
- (NSImage*)				resampledAndCroppedImageWithOpacity:(CGFloat) fraction;
- (BOOL)					hasClippingPath;
- (BOOL)					hasVisibleStyle;

- (BOOL)					writeImageToPasteboard:(NSPasteboard*) pb;

- (void)					setImageData:(NSData*) data;
- (NSData*)					imageData;

- (void)					setImageOpacity:(CGFloat) opacity;
- (CGFloat)					imageOpacity;

- (void)					setImageDrawsOnTop:(BOOL) onTop;
- (BOOL)					imageDrawsOnTop;

- (void)					setCompositingOperation:(NSCompositingOperation) op;
- (NSCompositingOperation)	compositingOperation;

- (void)					setImageScale:(CGFloat) scale;
- (CGFloat)					imageScale;

- (void)					setImageOffset:(NSPoint) imgoff constrain:(BOOL) constrain;
- (void)					setImageOffset:(NSPoint) imgoff;
- (NSPoint)					imageOffset;

- (void)					setImagePresentationMode:(DKImagePresentationMode) mode;
- (DKImagePresentationMode)	imagePresentationMode;

// user actions

- (IBAction)				toggleImageAboveAction:(id) sender;
- (IBAction)				copyImage:(id) sender;
- (IBAction)				pasteImage:(id) sender;
- (IBAction)				fitToImage:(id) sender;
- (IBAction)				removePath:(id) sender;
- (IBAction)				editImage:(id) sender;
- (IBAction)				cropImage:(id) sender;

@end


// partcodes used to represent operations such as interactive crop and scale


enum
{
	kDKImagePositioningPartcode				= ( 1 << 15 ),
	kDKImageScalingDirectControlPartcode	= ( 1 << 16 )
};


// deprecated methods
#define DRAWKIT_DKIMAGE_SHAPE_DEPRECATED		0

#if DRAWKIT_DKIMAGE_SHAPE_DEPRECATED

@interface DKImageShape (Deprecated)

- (id)						initWithPasteboard:(NSPasteboard*) pboard;
- (id)						initWithImageNamed:(NSString*) imageName;
- (BOOL)					setImageWithPasteboard:(NSPasteboard*) pb;
- (void)					setImageWithKey:(NSString*) key coder:(NSCoder*) coder;
- (void)					transferImageKeyToNewContainer:(id<DKDrawableContainer>) container;
- (void)					setImageKey:(NSString*) key;
- (NSString*)				imageKey;

- (void)					setImageCroppingOptions:(DKImageCroppingOptions) crop;
- (DKImageCroppingOptions)	imageCroppingOptions;
- (IBAction)				selectCropOrScaleAction:(id) sender;
- (NSImage*)				imageAtRenderedSize;


@end

#endif

// metadata keys for data installed by this object when created

extern NSString*	kDKOriginalFileMetadataKey;
extern NSString*	kDKOriginalImageDimensionsMetadataKey;
extern NSString*	kDKOriginalNameMetadataKey;

/*

DKImageShape is a drawable shape that displays an image. The image is scaled and rotated to the path bounds and clipped to the
path. The opacity of the image can be set, and whether the image is drawn before or after the normal path rendering.

This object is quite flexible - by changing the path clipping and drawing styles, a very wide range of different effects are
possible. (n.b. if you don't attach a style, the path is not drawn at all [the default], but still clips the image. The default
path is a rect so that the entire image is drawn.

There are two basic modes of operation - scaling and cropping. Scaling fills the shape's bounds with the image. Cropping keeps the image at its
original size and allows the path to clip it as it is resized. In both cases the image offset can be used to position the image within the bounds.
A hotspot is added to allow the user to drag the image offset position around.
 
 Image shapes automatically manage image data efficiently, such that if there is more than one shape with the same image, only one copy of
 the data is maintained, and that data is the original compressed data from the file (if it did come from a file). This data sharing is
 facilitated by a central DKImageDataManager object, which is managed by the drawing. Note that using certian operations, such as creating
 the shape with an NSImage will bypass this benefit.

*/
