//
//  DKIsometricGridLayer.h
//  GCDrawKit
//
//  Created by Graham Cox on 6/06/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import "DKGridLayer.h"

typedef enum
{
	kDKGridTypeCartesian		= 0,
	kDKGridTypeIsometric		= 1,
	kDKGridTypeDimetric			= 2
}
DKGridType;





@interface DKIsometricGridLayer : DKGridLayer <NSCoding, NSCopying>
{
@private
	CGFloat			mGridAngle;
	BOOL			mVerticalLines;
}


@property (assign,nonatomic) CGFloat	isoGridAngle;		// radians
@property (assign,nonatomic) BOOL		showsVerticalLines;

+ (DKIsometricGridLayer*)	isometricGridLayer;

- (CGFloat)					isoGridAngleInDegrees;
- (void)					setIsoGridAngleInDegrees:(CGFloat) degrees;

@end


#define ISOMETRIC_HORIZONTAL_CORRECTION_FACTOR			0.81649658092773


/*

An isometric grid is one with angled lines that form a grid of diamond-shaped cells. A standard isometric grid has 30° lines, but any angle can be set for other dimetric grids.
 
This subclass inherits the spacings and colours of the standard grid, but draws the lines angled, and implements snapping to the intersections of the lines. In all other respects it behaves
 the same way as the cartesian grid. Dimensions and distances are converted exactly as for DKGridLayer.

*/

