//
//  DKKnob.h
///  DrawKit �2005-2008 Apptree.net
//
//  Created by graham on 21/08/2006.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
//

#import <Cocoa/Cocoa.h>
#import "DKCommonTypes.h"


// visual flags, used internally

typedef enum
{
	kDKKnobDrawsStroke				= ( 1 << 0 ),
	kDKKnobDrawsFill				= ( 1 << 1 )
}
DKKnobDrawingFlags;


@class DKHandle;



@interface DKKnob : NSObject <NSCoding, NSCopying>
{
@private
	id				m_ownerRef;					// the object that owns (and hence retains) this - typically a DKLayer
	NSSize			m_knobSize;					// the currently cached knob size
	CGFloat			mScaleRatio;				// ratio to zoom factor used to scale knob size (default = 0.3)
	NSColor*		mControlBarColour;			// colour of control bars
	NSSize			mControlKnobSize;			// control knob size
	CGFloat			mControlBarWidth;			// control bar width
}

+ (id)				standardKnobs;
+ (void)			setControlKnobSize:(NSSize) size;
+ (NSSize)			controlKnobSize;

// main high-level methods that will be called by clients

- (void)			setOwner:(id<DKKnobOwner>) owner;
- (id<DKKnobOwner>)	owner;

- (void)			drawKnobAtPoint:(NSPoint) p ofType:(DKKnobType) knobType angle:(CGFloat) radians highlightColour:(NSColor*) aColour;
- (void)			drawKnobAtPoint:(NSPoint) p ofType:(DKKnobType) knobType angle:(CGFloat) radians userInfo:(NSDictionary*) userInfo;

- (void)			drawControlBarFromPoint:(NSPoint) a toPoint:(NSPoint) b;
- (void)			drawControlBarWithKnobsFromPoint:(NSPoint) a toPoint:(NSPoint) b;
- (void)			drawControlBarWithKnobsFromPoint:(NSPoint) a ofType:(DKKnobType) typeA toPoint:(NSPoint) b ofType:(DKKnobType) typeB;
- (void)			drawRotationBarWithKnobsFromCentre:(NSPoint) centre toPoint:(NSPoint) p;
- (void)			drawPartcode:(NSInteger) code atPoint:(NSPoint) p fontSize:(CGFloat) fontSize;

- (BOOL)			hitTestPoint:(NSPoint) p inKnobAtPoint:(NSPoint) kp ofType:(DKKnobType) knobType userInfo:(id) userInfo;
- (NSRect)			controlKnobRectAtPoint:(NSPoint) kp ofType:(DKKnobType) knobType;

- (void)			setControlBarColour:(NSColor*) clr;
- (NSColor*)		controlBarColour;
- (void)			setControlBarWidth:(CGFloat) width;
- (CGFloat)			controlBarWidth;

- (void)			setScalingRatio:(CGFloat) scaleRatio;
- (CGFloat)			scalingRatio;

// low-level methods (mostly internal and overridable)

- (void)			setControlKnobSize:(NSSize) cks;
- (void)			setControlKnobSizeForViewScale:(CGFloat) scale;
- (NSSize)			controlKnobSize;

// new model APIs

- (DKHandle*)		handleForType:(DKKnobType) knobType;
- (DKHandle*)		handleForType:(DKKnobType) knobType colour:(NSColor*) colour;
- (NSSize)			actualHandleSize;

@end

#pragma mark -

#define DK_KNOB_DEPRECATED_METHODS		0


#if DK_KNOB_DEPRECATED_METHODS

@interface DKKnob (Deprecated)

+ (void)			setControlKnobColour:(NSColor*) clr;
+ (NSColor*)		controlKnobColour;

+ (void)			setRotationKnobColour:(NSColor*) clr;
+ (NSColor*)		rotationKnobColour;

+ (void)			setControlOnPathPointColour:(NSColor*) clr;
+ (NSColor*)		controlOnPathPointColour;
+ (void)			setControlOffPathPointColour:(NSColor*) clr;
+ (NSColor*)		controlOffPathPointColour;

+ (void)			setControlBarColour:(NSColor*) clr;
+ (NSColor*)		controlBarColour;

+ (void)			setControlBarWidth:(CGFloat) width;
+ (CGFloat)			controlBarWidth;

+ (NSRect)			controlKnobRectAtPoint:(NSPoint) kp;

- (NSColor*)		fillColourForKnobType:(DKKnobType) knobType;
- (NSColor*)		strokeColourForKnobType:(DKKnobType) knobType;
- (CGFloat)			strokeWidthForKnobType:(DKKnobType) knobType;

// setting colours and sizes per-DKKnob instance

- (void)			setControlKnobColour:(NSColor*) clr;
- (NSColor*)		controlKnobColour;
- (void)			setRotationKnobColour:(NSColor*) clr;
- (NSColor*)		rotationKnobColour;

- (void)			setControlOnPathPointColour:(NSColor*) clr;
- (NSColor*)		controlOnPathPointColour;
- (void)			setControlOffPathPointColour:(NSColor*) clr;
- (NSColor*)		controlOffPathPointColour;

- (NSRect)			controlKnobRectAtPoint:(NSPoint) kp;

- (NSBezierPath*)	knobPathAtPoint:(NSPoint) p ofType:(DKKnobType) knobType angle:(CGFloat) radians userInfo:(id) userInfo;
- (void)			drawKnobPath:(NSBezierPath*) path ofType:(DKKnobType) knobType userInfo:(id) userInfo;
- (DKKnobDrawingFlags) drawingFlagsForKnobType:(DKKnobType) knobType;

- (void)			drawKnobAtPoint:(NSPoint) p ofType:(DKKnobType) knobType userInfo:(id) userInfo;

@end

#endif


// keys in the userInfo that can be used to pass additional information to the knob drawing methods

extern NSString*	kDKKnobPreferredHighlightColour;		// references an NSColor
extern NSString*	kDKKnobHandlePartcode;					// references an NSNumber containing the partcode of the handle being drawn
extern NSString*	kDKKnobMouseTrackingState;				// references an NSNumber (BOOL) with YES if mouse down, NO if mouse up.

// preferences keys

extern NSString* const	kDKHandleSizePreferencesKey;			// size of handles

// notifications

extern NSString* const	kDKHandleSizeDidChange;

/*

simple class used to provide the drawing of knobs for object selection. You can override this and replace it (attached to any layer)
to customise the appearance of the selection knobs for all drawn objects in that layer.

The main method a drawable will call is drawKnobAtPoint:ofType:userInfo:

The type (DKKnobType) is a functional description of the knob only - this class maps that functional description to a consistent appearance taking
into account the basic type and a couple of generic state flags. Clients should generally avoid trying to do drawing themselves of knobs, but if they do,
should use the lower level methods here to get consistent results.

Subclasses may want to customise many aspects of a knob's appearance, and can override any suitable factored methods according to their needs. Customisations
might include the shape of a knob, its colours, whether stroked or filled or both, etc.

*/
