//
//  DKMarkerStroke.h
//  DrawKit
//
//  Created by Graham on 22/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import "DKStroke.h"

@class DKDrawableObject;



typedef enum
{
	kDKMarkerAllVertices	= 0,
	kDKMarkerAtStart		= 1,
	kDKMarkerAtEnd			= 2,
	kDKMarkerAtCentre		= 3
}
DKMarkerPlacement;


typedef enum
{
	kDKMarkerOrientationAuto	= 0,
	kDKMarkerOrientationAngle	= 1
}
DKMarkerOrientation;


@interface DKMarkerStroke : DKStroke <NSCoding, NSCopying>
{
@private
	DKDrawableObject*		mMarker;				// the image drawn as the marker
	NSPoint					mRefPoint;				// alignment point relative to the marker where it aligns with the path
	NSSize					mMarkerSize;			// the desired size of the marker when drawn - the actual marker will be scaled to fit this size
	CGFloat					mAngle;					// the angle of the marker when orientation is not auto
	DKMarkerPlacement		mPlacement;				// where on the path the marker is drawn
	DKMarkerOrientation		mOrientation;			// whether to orient the marker automatically
	BOOL					mDrawInherited;			// whether the stroke attributes inherited from DKStroke are also drawn
	BOOL					mSizeRelToStrokeWidth;	// YES if size is acled by stroke width when calculating marker size
}

+ (DKMarkerStroke*)			markerStrokeWithMarker:(DKDrawableObject*) marker size:(NSSize) size placement:(DKMarkerPlacement) placement;

- (void)					setMarker:(DKDrawableObject*) marker;
- (DKDrawableObject*)		marker;

- (void)					setReferencePoint:(NSPoint) p;
- (NSPoint)					referencePoint;

- (void)					setMarkerSize:(NSSize) ms;
- (NSSize)					markerSize;
- (void)					setMarkerWidth:(CGFloat) mw;
- (CGFloat)					markerWidth;
- (void)					setMarkerHeight:(CGFloat) mh;
- (CGFloat)					markerHeight;

- (void)					setMarkerSizeRelativeToStrokeWidth:(BOOL) strokerel;
- (BOOL)					markerSizeRelativeToStrokeWidth;

- (void)					setAngle:(CGFloat) radians;
- (CGFloat)					angle;
- (void)					setAngleInDegrees:(CGFloat) degrees;
- (CGFloat)					angleInDegrees;

- (void)					setMarkerPlacement:(DKMarkerPlacement) placement;
- (DKMarkerPlacement)		markerPlacement;

- (void)					setMarkerOrientation:(DKMarkerOrientation) orient;
- (DKMarkerOrientation)		markerOrientation;

- (void)					setDrawsInheritedStroke:(BOOL) drawInhs;
- (BOOL)					drawsInheritedStroke;

@end



/*

Marker strokes draw the assigned object at each vertex, or at the start, end or middle of the rendered path.
 
 This kind of stroke is a more generalised form of the arrow stroke, and is here mainly to support markers imported from SVG documents.

*/


