//
//  DKPaperSize.h
//  GCDrawKit
//
//  Created by Graham Cox on 16/08/11.
//  Copyright 2011 Apptree. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface DKPaperSize : NSObject <NSCoding, NSCopying>
{
@private
	NSSize					mSize;
}

+ (DKPaperSize*)			paperWithWidth:(CGFloat) w height:(CGFloat) h;
+ (DKPaperSize*)			paperWithPrintInfo:(NSPrintInfo*) ip;

+ (DKPaperSize*)			isoA0PaperSize;
+ (DKPaperSize*)			isoA1PaperSize;
+ (DKPaperSize*)			isoA2PaperSize;
+ (DKPaperSize*)			isoA3PaperSize;
+ (DKPaperSize*)			isoA4PaperSize;
+ (DKPaperSize*)			isoA5PaperSize;

- (id)						initWithSize:(NSSize) size;

- (CGFloat)					width;
- (CGFloat)					height;
- (NSSize)					size;

- (DKPaperSize*)			landscape;
- (DKPaperSize*)			portrait;

- (DKPaperSize*)			halfSize;
- (DKPaperSize*)			halfSizeRotated;

- (BOOL)					isLandscape;
- (BOOL)					isPortrait;
- (BOOL)					isSquare;

@end


/*
 
 Simple data object used to represent a paper (or drawing) size.
 
 
 
 
 */


