//
//  DKRepeatTransformGroup.h
//  GCDrawKit
//
//  Created by Graham on 21/11/2013.
//  Copyright (c) 2013 Apptree. All rights reserved.
//

#import "DKRastGroup.h"

@interface DKRepeatTransformGroup : DKRastGroup <DKRenderable, NSCopying, NSCoding>
{
@private
	CGFloat			mDeltaX, mDeltaY;
	CGFloat			mScaleX, mScaleY;
	CGFloat			mDeltaAngle;
	NSUInteger		mNumRepeats;
	NSUInteger		mIteration;
	BOOL			mReversed;
	BOOL			mRelativeAngle;
	BOOL			mCompatibleMode;
	NSColor*		mBlendColour;
	id<DKRenderable>	mObject;
	NSPoint			mMidPoint;
}

@property (nonatomic, assign) CGFloat		deltaX;
@property (nonatomic, assign) CGFloat		deltaY;
@property (nonatomic, assign) CGFloat		scaleX;
@property (nonatomic, assign) CGFloat		scaleY;
@property (nonatomic, assign) CGFloat		deltaAngle;
@property (nonatomic, assign) NSUInteger	numberOfRepeats;
@property (nonatomic, assign) BOOL			angleIsRelative;
@property (nonatomic, assign) BOOL			reversed;
@property (nonatomic, assign) BOOL			compatibleMode;
@property (nonatomic, retain) NSColor*		blendColour;
@property (nonatomic, assign) id<DKRenderable> object;
@end



/*

This group replaces the individual rasterizer transform settings available previously. Using a group allows any effect or
 set of effects to be transformed. This is more efficient and more versatile.
 
 If the group has no repeats, it acts simply as a normal null group. If it has 1 or more repeats, this captures the original
 object's path, and then passes itself as the renderable to each rasterizer. This then returns the transformed path from its
 own -renderingPath method.
 
 For compatibility with older files, when DKRasterizer is dearchived, if it has repeat settings, an enclosing repeat group is
 created and the rasterizer is placed within it. The group is returned in place of the original rasterizer. The graphic effect
 is the same, but the actual structure of the style is different.

*/


