//
//  DKRoundRectShape.h
//  DrawKit
//
//  Created by Graham Cox on 7/12/10.
//  Copyright 2010 Mapdiva, LLC. All rights reserved.
//

#import "DKDrawableShape.h"


@interface DKRoundRectShape : DKDrawableShape <NSCopying, NSCoding>
{
@private
	CGFloat		mCornerRadius;
	BOOL		isDraggingRadiusControl;
}


- (void)		setCornerRadius:(CGFloat) radius;
- (CGFloat)		cornerRadius;

@end

enum
{
	kRoundRectRadiusControlPartcode		= ( 1 << 15 )
};


#define MAX_ROUNDRECT_CORNER_RADIUS		56.6929

/*

Implements a roundrect having a direct means for the user to drag a small handle to set the radius.

*/

