//
//  DKSVGImporter.h
//  DrawKit
//
//  Created by Graham on 17/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import "DKSVGParserDelegate.h"


@class DKDrawing, DKSVGElement, DKSVGContainerElement;



@interface DKSVGImporter : DKSVGParserDelegate
{
@private
	NSURL*					mFile;
	NSXMLParser*			mParser;
	NSMutableDictionary*	mDefs;
	DKDrawing*				mDrawing;
	BOOL					mReadingDefs;
	BOOL					mInvokingUseElement;
	BOOL					mShowsUI;
	NSTimeInterval			mStartTime;
	NSTimeInterval			mTimeout;
	NSMutableDictionary*	mStylesCache;
}

@property (assign, nonatomic ) NSTimeInterval	timeout;
@property (assign, nonatomic ) BOOL				showsUI;

+ (DKDrawing*)				drawingWithContentsOfSVGFile:(NSURL*) file;
+ (DKDrawing*)				drawingWithSVGData:(NSData*) data;

+ (void)					setDefaultSansFontFamily:(NSString*) fontFamily;
+ (void)					setDefaultSerifFontFamily:(NSString*) fontFamily;
+ (NSString*)				defaultSansFontFamily;
+ (NSString*)				defaultSerifFontFamily;

- (id)						initWithSVGFile:(NSURL*) file;
- (id)						initWithData:(NSData*) data;

- (void)					setSVGFile:(NSURL*) file;
- (NSURL*)					svgFile;
- (NSURL*)					urlWithRelativeReference:(NSString*) rel;
- (NSString*)				filename;

- (NSXMLParser*)			parser;

- (void)					setDrawing:(DKDrawing*) dwg;
- (DKDrawing*)				drawing;

- (NSMutableDictionary*)	stylesCache;

- (void)					setReadingDefs:(BOOL) rdefs;
- (BOOL)					readingDefs;
- (void)					setDefinedElements:(NSDictionary*) defs;
- (void)					addDefinedElement:(DKSVGElement*) element withID:(NSString*) idstr;
- (DKSVGElement*)			definedElementWithID:(NSString*) idstr;

- (id)						styleComponentOfType:(NSString*) type withURL:(NSString*) url;

- (void)					setInvokingUseElement:(BOOL) inUse;
- (BOOL)					invokingUseElement;

- (void)					updateTimer;

@end



#define DK_SVG_DEFAULT_TIMEOUT		8


extern NSString* DKSVGDefaultSansFontFamilyName;
extern NSString* DKSVGDefaultSerifFontFamilyName;

extern NSString* const	DKSVGImporterDidFinishNotification;

/*

This object is the top level object which sets up and parses the SVG XML file. It is the XMLParser's delegate,
 and hands off each SVG element to the appropriate class for further processing. The result of parsing the SVG file
 s a DKDrawing having the content of the SVG file converted to DK's internal representation. The drawing can then be assigned
 to a view or document as appropriate.
 
 This implements static SVG, i.e. no animation.
 
 If an error occurs during parsing, an appropriate exception is thrown.

*/

