//
//  DKSVGParserDelegate.h
//  DrawKit
//
//  Created by Graham on 21/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class DKSVGElement, DKSVGContainerElement, DKSVGImporter;



@interface DKSVGParserDelegate : NSObject <NSXMLParserDelegate>
{
@private
	DKSVGElement*			mParent;
	NSMutableArray*			mElementStack;
	NSInteger				mChildCount;
}

+ (NSDictionary*)			classTable;

- (void)					setParent:(DKSVGElement*) par;
- (DKSVGElement*)			parent;

- (DKSVGImporter*)			importer;

- (BOOL)					becomesParserDelegate;

- (NSMutableArray*)			elements;
- (void)					pushElement:(DKSVGElement*) element;
- (void)					popElement;

- (NSDictionary*)			classTable;
- (Class)					classForElementName:(NSString*) name;

- (DKSVGElement*)			currentElement;
- (void)					invokeFromUseElement;

@end


extern NSString*			DKSVGParseError;

/*

This is the semi-abstract base class for the importer and elements, being an object that can be set as an XMLParser's delegate, and hence
 respond to messages it sends to its delegate for each element, characters and so forth.
 
 It uses a class table to translate element names to objects (DKSVGElement instances) that know how to process each element
 type. Each element is pushed onto the element stack and removed when the element is complete. Each element only becomes the
 new parser delegate if it returns YES for -becomeParserDelegate, otherwise that element is handled by its parent.
 
 When an element does become a delegate, it is fully responsible for resetting the delegate to its parent on completion.

 Note that this is generally not used without subclassing - use DKSVGElement as a base class generally.

*/


