//
//  DKSVGPreview.h
//  GCDrawKit
//
//  Created by Graham Cox on 1/06/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import <Foundation/Foundation.h>


@class DKSVGImporter;



@interface DKSVGPreview : NSObject
{
@private
	id				mDelegateRef;
	DKSVGImporter*	mImporter;
	NSImage*		mImage;
}

@property (retain, nonatomic) id			delegate;		// delegate must be retained because operation is run on a thread and delegate must not disappear
@property (retain, nonatomic) NSImage*		image;

+ (NSURL*)		svgThumbnailsCacheFolder;
+ (void)		setSVGThumbnailsCacheFolder:(NSURL*) cf;

+ (NSImage*)	cachedSVGPreviewForURL:(NSURL*) url;
+ (void)		cacheSVGPreview:(NSImage*) image forURL:(NSURL*) url;
+ (void)		removeCachedSVGPreviewForURL:(NSURL*) url;
+ (void)		emptyCache;

+ (NSImage*)	imageForFailedParse;

+ (NSImage*)	svgPreviewWithSVGURL:(NSURL*) url delegate:(id) delegate;
+ (NSImage*)	svgPreviewWithSVGURL:(NSURL*) url delegate:(id) delegate allowingCachedImage:(BOOL) cachedOK;
+ (void)		cancelAllPreviews;

- (id)			initWithSVGFile:(NSURL*) svg	delegate:(id) delegate;
- (BOOL)		previewStillRequired;
- (NSURL*)		cachedPreviewURL;

@end


@interface NSObject (DKSVGPreviewDelegate)

- (BOOL)	svgPreviewShouldStart:(DKSVGPreview*) pv;
- (void)	svgPreviewDidStart:(DKSVGPreview*) pv;
- (void)	svgPreviewImageAvailable:(DKSVGPreview*) pv;
- (void)	svgPreviewDidEnd:(DKSVGPreview*) pv;
- (void)	svgPreviewFailed:(DKSVGPreview*) pv;

@end

#define DK_SVG_PREVIEW_MAX_SIMULTANEOUS_FETCHES		32

/*
 
 This object makes it easy to generate preview images from SVG files. Internally is converts the SVG file to a temporary drawing and then extract the image from the drawing.
 The parser runs on a thread so it calls back its delegate (on the main thread) when the image is available.
 
 
 */


