//
//  DKStyle+SVGStyles.h
//  DrawKit
//
//  Created by Graham on 17/03/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import "DKStyle.h"


@class DKSVGElement;



@interface DKStyle (SVGStyles)

+ (NSSet*)			cssStyleKeys;
+ (NSSet*)			graphicElementStyleKeys;

+ (NSString*)		nextSVGStyleName:(DKSVGElement*) context;
+ (DKStyle*)		styleWithSVGStyleString:(NSString*) ss context:(DKSVGElement*) context;
+ (DKStyle*)		styleWithSVGStyleString:(NSString*) ss context:(DKSVGElement*) context transform:(NSAffineTransform*) tfm;

+ (NSString*)		svgStyleStringFromAttributes:(NSDictionary*) attrs;
+ (NSDictionary*)	styleAttributesFromStyleString:(NSString*) str;
+ (NSDictionary*)	normalisedStyleAttributes:(NSDictionary*) attrs;

+ (DKRasterizer*)	styleComponentOfType:(NSString*) type withURL:(NSString*) url context:(DKSVGElement*) context;

+ (void)			setIgnoresFilterElements:(BOOL) ignoresFilters;
+ (BOOL)			ignoresFilterElements;

@end


/*

 converts an svg "style" parameter string to a DKStyle.
 
 This class aggressively caches the styles and tries to reuse and share them as far as possible, for efficiency.


*/


extern NSString* const kDKStyleSVGIgnoresFilterElementsDefaultsKey;