//
//  DKStyleHistory.h
//  GCDrawKit
//
//  Created by graham on 18/11/10.
//  Copyright 2010 Apptree.net. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class DKStyle;


@interface DKStyleHistory : NSObject
{
@private
	NSMutableArray*		mHistoryBuffer;
	NSUInteger			mMaxLen;
}

+ (DKStyleHistory*)		defaultHistory;

+ (void)				setCurrentStyle:(DKStyle*) aStyle;
+ (DKStyle*)			currentStyle;

- (void)				setMaximumLength:(NSUInteger) maxLen;
- (NSUInteger)			maximumLength;

- (NSArray*)			items;

- (void)				pushItem:(DKStyle*) aStyle;
- (DKStyle*)			popItem;
- (DKStyle*)			peekItem;

@end


#define		kDKDefaultStyleHistoryBufferLength		20


extern NSString*		kStyleHistoryNewStyleNotification;

/*

This class is a global singleton object that embodies the concept of "the current style", which can be set by a variety of
 sources, such as tools, the document selection, and so on. It provides a single place for any client, such as a style
 inspector, to locate the current style.
 
 As a further feature, it also implements a history buffer allowing the last n styles to be tracked.


*/


