//
//  DKTapRecogniser.h
//  GCDrawKit
//
//  Created by Graham Cox on 29/06/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import "DKGestureRecogniser.h"

@interface DKTapRecogniser : DKGestureRecogniser
{
@private
	NSTimeInterval			mLastTapTime;
	NSUInteger				mTapCount;
	NSUInteger				mFingerCount;
	NSUInteger				mRequiredTaps;
	NSTimer*				mTimer;
}

+ (NSTimeInterval)			doubleTapInterval;
+ (DKTapRecogniser*)		tapRecogniser;
+ (DKTapRecogniser*)		doubleTapTwoFingerRecogniser;

@property (assign, nonatomic) NSUInteger		requiredNumberOfFingers;
@property (assign, nonatomic) NSUInteger		requiredNumberOfTaps;
@property (readonly) NSUInteger					tapCount;

@end