//
//  DKUnarchivingHelper.h
//  GCDrawKit
//
//  Created by graham on 5/05/09.
//  Copyright 2009 Apptree.net. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@class DKDrawing;



@interface DKUnarchivingHelper : NSObject <NSKeyedUnarchiverDelegate>
{
@private
	NSUInteger	mCount;
	NSUInteger	mMaxCount;
	NSString*	mLastClassnameSubstituted;
	BOOL		mCancelled;
	BOOL		mForceDebug;
	NSMutableDictionary*	mDebugInfo;
	NSString*				mDebugClassname;
}

@property (nonatomic, assign) NSUInteger	totalNumberOfObjects;
@property (nonatomic, readonly) NSUInteger	numberOfObjectsDecoded;
@property (nonatomic, readonly) NSString*	lastClassnameSubstituted;
@property (atomic, assign, getter=isCancelled) BOOL	cancelled;
@property (nonatomic, assign) BOOL			forceDebugMode;
@property (nonatomic, readonly) NSDictionary* debugInfo;
@property (nonatomic, copy) NSString*		debugClassname;

- (void)		unarchiverWillStart:(NSKeyedUnarchiver*) unarchiver;
- (void)		reset;

- (void)		beginDebugging;
- (void)		endDebugging;

@end

// if a substitution would return NSObject, return this instead, which provides a stub for -initWithCoder rather than throwing
// an exception during dearchiving.

@interface DKNullObject : NSObject <NSCoding>
{
@private
	NSString*	mSubstitutedForClassname;
}

@property (nonatomic, copy) NSString*	substitutionClassname;

+ (DKNullObject*) null;

@end

extern NSString* const kDKDearchivingErrorDomain;


// this helper is used when unarchiving to translate class names from older files to their modern equivalents


